#!/usr/bin/python
# -*- coding: utf8 -*-
"""Status Bar Manager"""
import os.path,os
import mimetypes

from localize import _


class StatusBarManager:
        def __init__(self,CID):
            self.CID=CID
            self.filename = _("(UNTITLED)")
            self.language = _("(NONE)")
            self.status_line = {}
            self.statusbar = None

        def StatusBarManager(self, statusbar=None, language=None,filename=None):
            self.set_language(language)
            self.set_filename(filename)
            self.set_statusbar(statusbar)

        def set_language(self,language=None):
            self.language = language
            self.status_line['Language'] = self.language
            self.update_status()


        def set_filename(self,filename=None):
            self.filename = filename
            self.status_line['File'] = self.filename
            self.update_status()


        def set_statusbar(self,statusbar=None):
            self.statusbar = statusbar


        def update_status(self):
            cid = self.statusbar.get_context_id(self.CID)
            self.statusbar.push(cid,self.get_status())


        def reset_status(self):
            self.update_status()

        def set_status(self,string):
            cid = self.statusbar.get_context_id(self.CID)
            self.statusbar.push(cid,string)

        def get_status(self):
            status_string = _("File: %s | Language: %s") % (self.filename,self.language)

            return status_string

