# -*- coding: utf8 -*-
#Создает рамку на основе выбраных цветов фона и "переда"
#Создано на основе http://blogpost.am9.ru/?cat=14

import gimp
from gimpfu import pdb
from gimpfu import *

width=20

images = gimp.image_list() 
image = images[0]
image.undo_group_start()

old_background_color = pdb.gimp_context_get_background()
old_foreground_color = pdb.gimp_context_get_foreground()

image_width  = pdb.gimp_image_width(image)
image_height = pdb.gimp_image_height(image)
# get a copy of background
background_copy = pdb.gimp_image_get_active_layer (image)
border = pdb.gimp_layer_copy(background_copy,0)
pdb.gimp_image_add_layer(image, border, -1)
#select and make stroke
pdb.gimp_rect_select(image, width, width,  image_width - 2*width , image_height - 2*width , CHANNEL_OP_REPLACE,  0, 0.0)

drawable = pdb.gimp_image_active_drawable (image)
# TODO somehow set the width for the stroke
pdb.gimp_edit_stroke(drawable)
# fill by foreground color
pdb.gimp_selection_invert(image)

pdb.gimp_context_set_foreground(old_background_color)

drawable = pdb.gimp_image_active_drawable (image)
pdb.gimp_bucket_fill(drawable,FG_BUCKET_FILL,NORMAL_MODE,100,0,0,width/2,width/2)
pdb.gimp_layer_set_opacity(border,50)
pdb.gimp_selection_none (image)
# megre visible layers
pdb.gimp_image_merge_visible_layers(image,EXPAND_AS_NECESSARY)

pdb.gimp_context_set_foreground(old_foreground_color)
pdb.gimp_context_set_background(old_background_color)

image.undo_group_end()
gimp.displays_flush()  