#!/usr/bin/env python

#!/usr/bin/env python
# -*- coding: utf-8 -*-

# Plug-in:      Quick and dirty color value enhancement with a fixed S-Curve.
# Version:      0.1
# Date:         16.03.2013
# Copyright:    Klaas van Rijt    
# Tested with:  GIMP 2.8
# ----------------------------------

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from gimpfu import *

def s_enhance(img, drw):

	gimp.context_push()
	img.undo_group_start()

	pdb.gimp_curves_spline(drw, 0, 8, (0, 0,  45, 20, 190, 220, 255, 255))

	img.undo_group_end()
	gimp.context_pop()

register(
	"python-fu-s-enhance",
	"Quick and dirty color value enhancement with a fixed S-Curve.",
	"Quick and dirty color value enhancement with a fixed S-Curve.",
	"Klaas van Rijt",
	"Klaas van Rijt",
	"March 2013",
	"Enhance Values...",
	"RGB*, GRAY*",
	[
		(PF_IMAGE, "image",       "Input image", None),
		(PF_DRAWABLE, "drawable", "Input drawable", None),
	],
	[],
	s_enhance,
	menu="<Image>/Colors/Q&D",
	domain=("gimp20-python", gimp.locale_directory)
	)

main()
