#!/usr/bin/env python

#!/usr/bin/env python
# -*- coding: utf-8 -*-

# Plug-in:      Balance colors through samples indicated as gray.
# Version:      0.1
# Date:         16.03.2013
# Copyright:    Klaas van Rijt    
# Tested with:  GIMP 2.8
# ----------------------------------

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from gimpfu import *

def gray_right(img, drw):

	sample_radius = 5.0

	gimp.context_push()
	img.undo_group_start()

	arr_points = pdb.gimp_path_get_points(img,pdb.gimp_path_get_current(img))

	arr_red = [0,0]
	arr_blue = [0,0]
	int_points = 2
	
	for i in range(0, arr_points[2], 3):
		if (arr_points[3][i+2] == 1):
			arr_colors = pdb.gimp_image_pick_color(img, drw, str(arr_points[3][i]), str(arr_points[3][i+1]),FALSE ,TRUE, sample_radius)
			arr_red.append(arr_colors[0])
			arr_red.append(arr_colors[1])
			arr_blue.append(arr_colors[2])
			arr_blue.append(arr_colors[1])
			int_points += 2

	arr_red.append(255)
	arr_red.append(255)
	arr_blue.append(255)
	arr_blue.append(255)
	int_points += 2
		
	pdb.gimp_curves_spline(drw, 1, int_points, arr_red)
	pdb.gimp_curves_spline(drw, 3, int_points, arr_blue)

	img.undo_group_end()
	gimp.context_pop()

register(
	"python-fu-gray-right",
	"Correct Color Balance with Gray samples contained in a path.",
	"Balance the colors of a drawable with a path that contains points which indicate Gray areas (i.e. equal RGB values).\n"
	"The radius of the area samples is currently hard coded in the script.\n"
	"Taking samples of different shades of gray may improve results. Think of highlight and shade for example.",
	"Klaas van Rijt",
	"Klaas van Rijt",
	"March 2013",
	"Correct Grays...",
	"RGB*",
	[
		(PF_IMAGE, "image",       "Input image", None),
		(PF_DRAWABLE, "drawable", "Input drawable", None),
	],
	[],
	gray_right,
	menu="<Image>/Colors/Q&D",
	domain=("gimp20-python", gimp.locale_directory)
	)

main()
