#!/usr/bin/env python

'''
Document a gimp module written in python.
Works for plugins or pygimp modules or any other python module.
This is a submodule for the gimp inspect plugin.

A special use of pydoc: plain text document.

History: I tried modifying pydoc to produce treeviews on the documents,
and a different style of document,
but decided not worthwhile.

!!! Note this depends on a future enhancement to Gimp that lets plugins be imported twice,
suppressing aborts on "gimp_env_init must be called once".
'''


from pydoc import render_doc, plain

def document_module(db, name, titleformat):
  '''
  Load a dictionary with documents for Gimp plugins or other modules written in Python.
  Understands that pydoc generates documents.
  '''
  print name
  # !!! plain removes overstrike chars used for bold on printer like devices.
  # render_doc is text (alternative is html).
  # titleformat tells render_doc the title to put into the document.  title format eg "Foo: %s".
  # values in dict are simple string objects.
  try:
    db[name] = plain(render_doc(name, titleformat))
  except ImportError:
    print "pydoc import error: ", name
    pass


class PackagedModuleDocument():

  def __init__(self, doc, path):
    self.path = path
    self.document = doc
  
  def __repr__(self):
    return self.document

def document_packaged_module(db, name, titleformat, path):
  '''
  Load a dictionary with documents for packaged modules written in Python.
  Understands that pydoc generates documents.
  Understands the tree structure of packages.
  name is the suffix of path.
  '''
  print name
  # See above, but now db values are objects with path attribute, the package path to the documented module.
  # Package paths eg package.submodule.module, but here slash delimited.
  slashpath = path.replace(".", "/")
  try:
    # Pass fully qualified, dotted path not just the name.
    # Otherwise pydoc imports and finds other modules with the same short, unqualified name.
    document = plain(render_doc(path, titleformat))
    value = PackagedModuleDocument(document, slashpath)
    db[name] = value
  except ImportError:
    print "pydoc import error: ", name
    pass

