#!/usr/bin/env python

'''
Inspect pygimp modules.
This is a submodule for the gimp inspect plugin.
It defines a view and creates a dictionary of documents for the inspector.

See inspectplugins.py and inspectlocalplugins.py.

!!! Note this depends on a future enhancement to Gimp that lets plugins be imported twice,
suppressing aborts on "gimp_env_init must be called once".
'''


from documentmodule import document_module
import inspector.db_treemodel
from db_treemodel import VIEW_TYPE_LIST


def document_pyplugins(db):
  '''
  Load a dictionary with document objects for Gimp plugins written in Python.
  Understands what the set of pygimp modules is.
  '''
  for modulename in ('gimp', 'gimpfu', 'gimpshelf', 'gimpenums', 'gimpplugin'):
    document_module(db, modulename, "Python Gimp Module: %s")
  

'''
define views on db.
'''

mydb = {}
document_pyplugins(mydb)
mydbfilterdict = inspector.search.TreeModelFilterDict(mydb)
# dictionary of views
dictofviews = {}  # Exported, the main product
dictofviews["GIMP-Python modules"] = inspector.db_treemodel.ViewSpec("GIMP-Python modules", None, VIEW_TYPE_LIST, None, mydb, mydbfilterdict)      
  
