#!/usr/bin/env python

'''
Inspect python packages in the users gimp plug-ins directory.
This is a submodule for the gimp inspect plugin.
It defines a view and creates a dictionary of documents for the inspector.

See inspectpyplugins.py for other relevant comments.

??? Apparently this module can't document itself:
pydoc import error: inspectpypackages
A limitation of pydoc?
'''


import documentmodule
import inspector.db_treemodel
from db_treemodel import VIEW_TYPE_SLASHPATH
import os
import fnmatch




def document_pypackages(db):
  '''
  Load a dictionary with document objects for Python packages in the user's Gimp plug-ins directory.
  Understands the structure of Python packages.
  Rely on gimp module to understand directories.
  Tree structure of packages, documents for leaf modules.
  '''
  
  
  from gimp import plug_in_directory, directory  # PyGimp knows paths to plug-ins directories
  # !!! Note user local, hidden, gimp directory is in variable gimp.directory
  PLUGIN_DIRECTORY_NAME = 'plug-ins'
  localdirectorypath = os.path.join(directory, PLUGIN_DIRECTORY_NAME)
  # eg ~/.gimp-2.6/plug-ins
  
  ''' Commented out unless gimp is patched for reimport.
  '''
  
  # Walk packages.
  # TBD This is limited to one level, should be more generic.
  import pkgutil
  for importer, outername, ispkg in pkgutil.walk_packages([localdirectorypath]): #onerror=onerror):
    if ispkg:
      print "Package: ", outername
      for imp, mod, foo in pkgutil.walk_packages([localdirectorypath + "/" + outername]):
        if foo:
          print "!!! Subpackage not implemented"
        else:
          # print "Mod", mod
          # Note we pass a Python dot delimited path
          path = outername + "." + mod
          documentmodule.document_packaged_module(db, mod, "%s", path)
  
  
  # For demo when pygimp is NOT patched
  # path = localdirectorypath + "/" + outername
  # documentmodule.document_packaged_module(db, inspector, "%s", path)
  

'''
define views on db.
'''

mydb = {}
document_pypackages(mydb)
mydbfilterdict = inspector.search.TreeModelFilterDict(mydb)
# dictionary of views
dictofviews = {}  # Exported, the main product
# the package name is in the 'path' attribute of the db values
dictofviews["User Python packages"] = inspector.db_treemodel.ViewSpec("User Python packages", "path", VIEW_TYPE_SLASHPATH, None, mydb, mydbfilterdict)      
  
