#!/usr/bin/env python

'''
Inspect gimp plugins written in the python language.
This is a submodule for the gimp inspect plugin.
It defines a view and creates a dictionary of documents for the inspector.
This is for the plugins that are distributed with gimp or are installed in the gimp plug-ins directory.
See inspectlocalplugins.py for locally installed or written plugins.

!!! Note this depends on a future enhancement to Gimp that lets plugins be imported twice,
suppressing aborts on "gimp_env_init must be called once".
'''


from documentmodule import document_module
import inspector.db_treemodel
from db_treemodel import VIEW_TYPE_LIST
import os
import fnmatch




def document_pyplugins(db):
  '''
  Load a dictionary with document objects for Gimp plugins written in Python.
  Understands where the plugins live.
  Rely on gimp module to understand directories.
  '''
  
  '''
  This is commented out unless gimp is patched so that plugins can be imported twice
  without aborting "gimp_env_init() must only be called once."
  
  from gimp import plug_in_directory, directory  # PyGimp knows paths to plug-ins directories
  # !!! Note local directory is unqualified 'directory', where this plugin lives
  PLUGIN_DIRECTORY_NAME = 'plug-ins' 
  
  # plugins distributed with Gimp or installed to standard Gimp directory
  directorypath = os.path.join(plug_in_directory, PLUGIN_DIRECTORY_NAME) 
  
  # Note that PyGIMP puts the local plugins in the path but not the distributed ones?
  import sys
  sys.path.extend([directorypath])
  # print sys.path, directorypath
  
  for file in os.listdir(directorypath):
    if fnmatch.fnmatch(file, '*.py'):
        # filepath = directory + 
        fileprefix = file[:-3]
        document_module(db, fileprefix, "Plugin: %s")
  
  # User's local plugins
  localdirectorypath = os.path.join(directory, PLUGIN_DIRECTORY_NAME) 
  for file in os.listdir(localdirectorypath):
    if fnmatch.fnmatch(file, '*.py'):
        # filepath = directory + 
        fileprefix = file[:-3]
        document_module(db, fileprefix, "Plugin: %s")
  '''
  
  '''
  It documents package foo but not foo.py when both in same directory?
  That is, pydoc imports foo and finds the package, not foo.py.
  There is no solution, its a feature of the Python import statement,
  We could give a warning if the same name is found twice.
  '''
        
  # Use this for demonstration if pygimp is not patched for reimport
  # IE only document plugins that guard calls to main() 
  print "Documenting plugin-inspect"
  document_module(db, 'plugin-inspect', "Plugin: %s")

  
 


  

'''
define views on db.
'''

mydb = {}
document_pyplugins(mydb)
mydbfilterdict = inspector.search.TreeModelFilterDict(mydb)
# dictionary of views
dictofviews = {}  # Exported, the main product
dictofviews["Plugins in Python language"] = inspector.db_treemodel.ViewSpec("Plugins in Python language", None, VIEW_TYPE_LIST, None, mydb, mydbfilterdict)      
  
