#!/usr/bin/env python

'''
Search/filter functions for generic inspector app implemented using Glade and GtkBuilder.
Maintains a dictionary[named row of model]->boolean
'''

# Dependencies:
# No dependency on the db, eg doesn't understand that the db might be the Gimp PDB

import re


class FilterString(object):
  '''
  User specified search/filter string.
  Set a string, get a pattern.
  Caching (probably not needed.)
  Understands the app's hardwired parameters for re.search, ie ignore case.
  Hardwired: user given few choices for search parameters.
  '''
  
  def __init__(self):
    self.cachedsearchstring = ""
    self.pattern = ""   # Arg to re.search, which can be a string, but here usually a compiled pattern
    
  def setstring(self, newsearchstring):
    ''' Set a searchstring. '''

    # compile and cache regular expression
    if not newsearchstring == self.cachedsearchstring :
      self.cachedsearchstring = newsearchstring
      # !!! re.S (synonymous re.DOTALL) means match newlines ie search all lines of text
      # re.I ignore case, re.L use Locale
      self.pattern = re.compile(newsearchstring, re.S | re.I | re.L)
  
  def getpattern(self):
    return self.pattern



class TreeModelFilterDict(dict):
  '''
  Dictionary for filtering gtk treemodel.
  Boolean valued.
  True means unfiltered, ie displayed in GUI.
  '''

  def __init__(self, sourcedict):
    
    # Base class init
    dict.__init__(self, sourcedict)
   
    # Fill self from sourcedict
    for key, value in sourcedict.iteritems():
      dict.__setitem__(self, key, True)  # initially display all


  def filter(self, sourcedict, pattern):
    '''
    Find what matches filter using searchstring and pattern set earlier.  
    Doesn't reset the model, just the filter dictionary.
    Returns the count of matches (filtered in, shown)
    '''
    for name, value in sourcedict.iteritems():
      # Note re.search finds anywhere, re.match finds just at start
      is_shown = re.search(pattern, str(value) ) is not None
      dict.__setitem__(self, name, is_shown)
       
    return dict.values(self).count(True)


  

'''
# OLD follows, work in progress to use filtering hooks built into treemodel

def search_func(model, iter):
  
  #The set_visible_func called for each row when the treemodelfilter is refiltered().
  #Parameter: data is not used
  
  global cachedsearchstring, pattern, documentdictionary
  # if this row is not a leaf?
  # if we filter it out, we loose the tree?
  
  # if searchstring is blank, no filtering
  if cachedsearchstring == "":
    return True
  
  # !!! Surprise: model.get() gets a tuple, get_value() gets a single column
  name = model.get_value(iter, 1) # second column is hidden name
  if name:  # if not empty string
    return re.match(pattern, documentdictionary[name])
  else:  #else is not a leaf?
    return True
  # TBD don't hide the menu paths if they have an unfiltered row beneath them?
''' 
    
