#!/usr/bin/env python

'''
Gimp Inspect

  This is the outer layer, registering as plugin (or not) and calling the GUI app.

  Installation:

  cp plugin-inspect.py ~/.gimp-2.6/plug-ins (user's local directory)
  chmod +x ~/.gimp-2.6/plug-ins/plugin-inspect.py
  cp -r inspector ~/.gimp-2.6/plug-ins
  (copy the inspector directory which comprises .glade and .py files)
  
  
  Copyright (C) 2010 Lloyd Konneker      bootch at nc.rr.com
    
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 
'''


def plugin_main():
    import inspector.gui  # import package that is meat of plugin
    
    # Build data that drives the app: dictionary of views on dbs
    # For each kind of db, import the glue module to the db
    # and get the dictofviews from the glue module
    
    import inspector.inspectpdb # glue to the Gimp PDB
    dictofviews = inspector.inspectpdb.dictofviews.copy()
    
    # This is not of much use, info is available elsewhere
    import inspector.inspectimage
    dictofviews.update(inspector.inspectimage.dictofviews)
    
    import inspector.inspectpygimp
    dictofviews.update(inspector.inspectpygimp.dictofviews)
    
    import inspector.inspectpyplugins
    dictofviews.update(inspector.inspectpyplugins.dictofviews)
    
    import inspector.inspectpypackages
    dictofviews.update(inspector.inspectpypackages.dictofviews)
    
    app = inspector.gui.InspectorApp(dictofviews)  # create instance of gtkBuilder app
    app.main()  # event loop for app


if __name__ == "__main__":
    # if invoked from Gimp app as a plugin
    from gimpfu import *    
    
    # Note: keyword param 'menu=' helps enable this plugin regardless is open image.
    register(
        "python_fu_inspector",
        "Inspect Gimp plugins, procedures, PyGimp objects, and image properties.",
        "Programmer's inspector",
        "Lloyd Konneker (bootch nc.rr.com)",
        "Copyright 2009 Lloyd Konneker",
        "2009",
        "_Inspect",
        "", # image types: blank means don't care but no image param
        [],
        [],
        plugin_main,
        menu="<Image>/Filters/Languages")   # Languages means: same group as Python-Fu
        # This is really the menupath, the menuitem is prior
        # !!! But note no parameters are passed.
        
        # domain=("gimp20-python", gimp.locale_directory))
    
    print "Starting plugin-inspect"
    main()



