/*_ Magie library                                   _*/
/*_ Copyright (c) 2007, Ivan Bezdomniy              _*/
/*_ This program is free software. It may be distributed
 * and/or modified under the terms of the Lesser General
 * Public License. See the GNU Lesser General Public
 * License for more details */


/*_ Dynamic Range Conversion Toolit		_*/

#ifndef __DRCONV_LIBRARY
#define __DRCONV_LIBRARY



/*_ Available conveyers		_*/
/* DR Unifiers				*/
#define	DRT_DRU_PLINEAR		0x0001	/* Piecewise linear DR Unifier	*/



/*_ Common settings interface	_*/
struct DRC_Common {
	float		T;	/* Attraction value			*/
	float		kc;	/* Contrast value			*/
	float		ks;	/* Attraction speed			*/
	float		kr;	/* Regression spot			*/
	float		wr;	/* Range widness factor		*/
	float		Tr;	/* Transfer widness factor	*/
	float		As;	/* DR Assymetry value		*/
};


/*_ PLINEAR Enviroment conveyer	_*/
struct DRU_PL_Env {
	
};



/*_ DRC control object			_*/
typedef struct DRC_Obj {
	unsigned int		conveyer;	/* Conveyer type	*/
	/* Control flags		*/
	struct {
		int		fl_valid	:1;		/* Settings are ok	*/
		int		fl_ready	:1;		/* Conveyer ready	*/
	};
	struct	DRC_Common	parm;		/* Common params	*/
	/* Conveyers enviroment	*/
	union {
		struct DRU_PL_Env	pline;
	};


} DRC_OBJ;



/*_ DR Conveyers validators		_*/
int			drc_validate(DRC_OBJ*);
/*_ DR Conveyers				_*/
int			drc_conveyer(DRC_OBJ*, float*, float*,uint16_t*, uint16_t*, int);


#endif/*__DRCONV_LIBRARY */


