/*_ Magie library                                   _*/
/*_ Copyright (c) 2007, Ivan Bezdomniy              _*/
/*_ This program is free software. It may be distributed
 * and/or modified under the terms of the Lesser General
 * Public License. See the GNU Lesser General Public
 * License for more details */



#include <math.h>
#include <stdint.h>

#include "magie/drconv.h"


/* Shotcuts for parms reference	*/
#define	_P(_v)	(obj->parm._v)



int		drc_validate(DRC_OBJ*	obj) {
	if (! obj) return -1;

	#define	_PR_BNDU(_v) { 			\
		if (_v < 0) _v = 0; else	\
		if (_v > 1) _v = 1;	 }

	#define	_PR_BNDS(_v) {			\
		if (_v < -1) _v = -1; else	\
		if (_v > +1) _v = +1; }

	/*_ Bound common settings			_*/
	_PR_BNDU(obj->parm.T);
	_PR_BNDU(obj->parm.ks);
	_PR_BNDU(obj->parm.kr);
	_PR_BNDU(obj->parm.Tr);
	_PR_BNDS(obj->parm.kc);
	_PR_BNDS(obj->parm.wr);
	_PR_BNDS(obj->parm.As);
	

	/*_ Build enviroment for conveyers	_*/
	if (obj->conveyer == DRT_DRU_PLINEAR) {



	} else
		return -1;

	/*_ Validate control object			_*/
	obj->fl_valid	= 1;
	obj->fl_ready	= 1;

	return 0;
}




/* Dynamic range estimator engine	*/
int  drc_conveyer(
  		DRC_OBJ*		obj,
		float*			vin,	/* Input values		*/
		float*			vou,	/* Output values	*/
		uint16_t*		v_avg,	/* AVG values		*/
		uint16_t*		v_sqr,	/* SQR values		*/
		int				count) {
	double	Y, Tn, Fl, Kr, Cw, Fc, Tk;
	float		avg;
	float		sqr;
	float		amp;
	float		nkc;

	/* Sanity checkups for input parms	*/
	if (!obj)				return -1;
	if (!vin || !vou)		return -1;
	if (!v_avg || !v_sqr)	return -1;
	/* Sanity checkups for object state	*/
	if (!obj->fl_valid)		return -1;
	if (!obj->fl_ready)		return -1;
	/* Exclude NOOP execution			*/
	if (!count)				return 0;


	Fl = 0.95;	/* Attraction floor	*/
	Fc = 0.8/2;	/* Contrast floor	*/

	/* Calc common values	*/
	if (_P(kc) <= 0) nkc = 1.0 + _P(kc); else
	if (_P(kc) >  0) nkc = 1.0/(1.01 - _P(kc));

	while (count--) {
		/* Cache source values			*/
		amp = vin[0];
		avg	= ((float)v_avg[0])/(128*256 - 1);
		sqr	= ((float)v_sqr[0])/(128*256 - 1);
		sqr = sqrtf(fabsf(sqr - avg*avg));

		/*_ @@ T0: Update sqr with limit & width_*/
		{
			if (sqr > 0.5) sqr = 0.5; else
			if (sqr < 0.0) sqr = 0.0;

			if (_P(wr) >= 0)
				sqr = sqr * (1 - _P(wr)) + 0.5*_P(wr);
			else
				sqr = sqr * (1 + _P(wr));
		}

		/*_ @@ T2: Regression scale for borders	_*/
		{
			/* Regression scale system will be
			 * obsolted as standalone one and
			 * will be intergrated into point
			 * transfer function, see T4  */

			double	L, XB, K3;

			L = (amp < 0.5) ? amp : 1 - amp ;

			XB = _P(kr) * Fl/2;
			K3 = (1 - Fl)/(0.5 - XB);

			if (L < XB)   Kr = 2*L / _P(kr); else
			if (L <= 0.5) Kr = K3*(L - 0.5) + 1;
			else		  Kr = 1;
		}
 
		/*_ @@ T3: Target geometry				_*/
		{
			double	diff;

			diff = _P(T) - avg;

			/* DR Assymmetry transform			*/
			if (_P(As) != 0) {
				if (_P(As) > 0 && diff < 0) {
					diff *= 1 - _P(As);
				} else
				if (_P(As) < 0 && diff > 0){
					diff *= 1 + _P(As);
				}
			}

			/* Target unity transformation		*/
			Tn = avg + diff * _P(ks) * Kr;
		}

		/*_ @@ T4: Transfer point (S->T)		_*/
		{
			double	L, M, K1, K2, K3, G;
			double	XA, YA, XB, YB;

			L = (avg < Tn) ? avg : Tn;
			M = (avg > Tn) ? avg : Tn;

			if (_P(Tr) == 0)
				G = 0;
			else
				G = (1 - _P(Tr))/(1 - (1 - 2*sqr) * _P(Tr));

			if (L > 0) {
				K1 = (M - 1) / L;
				K2 = (1 + G * (M - 1) ) / (G * L);

				XA = (L - M) / (1 - K2);
				YA = XA*K2;
			} else {
				XA = 0;
				K2 = 1;
			}

			K3 = G *(M - 1) / (G * L - 1);

			XB = 1 + (L - M) / (1 - K3);
			YB = XB + M - L;

			if (Tn < avg) {
				double	I;

				I = XA; XA = YA; YA = I;
				I = XB; XB = YB; YB = I;

				K2 = 1/K2;
				K3 = 1/K3;
			}

			if (amp < XA) { Y = K2 * amp; } else
			if (amp < XB) { Y = amp + Tn - avg; } else
			if (amp <= 1) { Y = K3*(amp - 1) + 1; }
			else
				{ Y = 1; }

			Y = (Y > 1) ? 1 : Y;
			amp = Y;
		}

		/*_ @@ T5: Contrast transformation		_*/
		{
			double	XA, YA, XB, YB, Df, TL, TR, S;
			double	*L, *R;

			XA = Tn - sqr;
			XB = Tn + sqr;
	
			YA = Tn - sqr * nkc;
			YB = Tn + sqr * nkc;

			TL = _P(Tr) * Tn;
			TR = _P(Tr) * (1 - Tn); 

			/* Bound (XA, YA) & (XB, YB) to (1,1)*/
			
			if ( nkc > 1)
				{ L = &YA; R = &YB; S = sqr * nkc; }
			else
				{ L = &XA; R = &XB; S = sqr * 1; }

			if (*L < TL)
				*L = TL*( (*L - TL)/(S + TL) + 1);
			if (*R > 1 - TR)
				*R = 1 - TR*( (1- *R - TR)/(S + TR) + 1);

			if (nkc > 1){
				XA = Tn + (YA - Tn)/nkc;
				XB = Tn + (YB - Tn)/nkc;
			} else {
				YA = Tn + (XA - Tn)*nkc;
				YB = Tn + (XB - Tn)*nkc;
			}

			/* Map value						*/
			if (amp <= 0)  Y = 0; else
			if (amp <= XA) Y = (YA/XA) * amp; else
			if (amp <= XB) Y = nkc * (amp - XA) + YA; else
			if (amp <= 1.0)Y = ((1-YB)/(1-XB))*(amp-XB)+YB;
			else amp = 1;

			amp = Y;
		}


		if (amp > 1 || amp < 0) {
		}

		/* Sanity bounds				*/
		if (amp < 0) amp = 0;
		if (amp > 1) amp = 1;

		vou[0] = amp;

		/* Incriment buffer pointers	*/
		vin++;   vou++;
		v_avg++; v_sqr++;
	}

	return 	0;
}
	

