/*_ Magie library                                   _*/
/*_ Copyright (c) 2007, Ivan Bezdomniy              _*/
/*_ This program is free software. It may be distributed
 * and/or modified under the terms of the Lesser General
 * Public License. See the GNU Lesser General Public
 * License for more details */


/*_ Pixels model libtaty	_*/



#include <stdint.h>
#include "magie/pixmodel.h"


/*_ Intermediate macro definition	_*/
#define	_PIX_RGB_MAX(_stype, __p, __v) {\
	_stype		___tv;		\
	_stype*		___p;		\
	___p = (_stype*) (__p);	\
	___tv= ___p[0];			\
	if (___p[1] > ___p[0]) ___tv = ___p[1];\
	if (___p[2] > ___tv)   ___tv = ___p[2];\
	__v = ___tv; }


#define	_PIX_RGB_MIN(_stype, _p, _v) {\
	_stype		___tv;		\
	_stype*		___p;		\
	___p = (_stype*) (_p);	\
	___tv= ___p[0];			\
	if (___p[1] < ___p[0]) ___tv = ___p[1];\
	if (___p[2] < ___tv)   ___tv = ___p[2];\
	_v = ___tv; }


/*_ Pixmodels value retrival		_*/
#define	_PIX_RGB_HSV_V(_stype, _itype , _p, _v){\
	_itype		__tv;				\
	_stype*		__p;				\
	__p = (_stype*) (_p);			\
	_PIX_RGB_MAX(_stype, _p, __tv);	\
	_v = __tv; }


#define	_PIX_RGB_HSL_L(_stype, _itype , _p, _v){\
	_itype		__tv;				\
	_itype		__tw;				\
	_stype*		__p;				\
	__p = (_stype*) (_p);			\
	_PIX_RGB_MAX(_stype, _p, __tv);	\
	_PIX_RGB_MIN(_stype, _p, __tw);	\
	_v = (__tv + __tw)/2; }


#define	_PIX_RGB_BRIGHT(_stype, _itype, _p, _v){\
	_itype		__tv;		\
	_stype*		__p;		\
	__p = (_stype*) (_p);	\
	__tv = __p[0];			\
	__tv+= __p[1];			\
	__tv+= __p[2];			\
	__tv/= 3;				\
	_v = __tv; }


#define	_PIX_RGB_LUMA(_stype, _itype, _p, _v){\
	_itype		__tv	;	\
	_stype*		__p;		\
	__p = (_stype*) (_p);	\
	__tv = 0.2126 * __p[0];	\
	__tv+= 0.7152 * __p[1];	\
	__tv+= 0.0722 * __p[2];	\
	_v = __tv; }





void	pixmodel_rgb_to_v(
			void*		pixels,		/* Pixel buffer		*/
			float*		values,		/* Values			*/
			int			count,		/* Pixel counts		*/
			PXM_MODEL	type,		/* Pixel model		*/
			int			usize) {	/* Pixel size, bytes*/
	float	value;

	#define	__PIX_PM	uint8_t,uint_fast16_t, p_rgb, value

	if (type == PIXEL_GRAY_VALUE) {
		uint8_t*	p_gray = (uint8_t*)pixels;

		while (count--) {
			*(values++) = ((float)p_gray[0])/255;
			p_gray += usize;
		}
	} else {
		uint8_t*	p_rgb = (uint8_t*)pixels;

		while (count--) {
			if (type == PIXEL_HSV_VALUE) {
				_PIX_RGB_HSV_V(uint8_t, uint_fast16_t, p_rgb, value);
			} else
			if (type == PIXEL_HSL_LIGHTNESS) {
				_PIX_RGB_HSL_L(uint8_t, uint_fast16_t, p_rgb, value);
			} else
			if (type == PIXEL_LUMA) {
				_PIX_RGB_LUMA (uint8_t, uint_fast16_t, p_rgb, value);
			} else
			if (type == PIXEL_BRIGHTNESS) {
				_PIX_RGB_BRIGHT(uint8_t, uint_fast16_t, p_rgb, value);
			}

			*(values++) = value/255;
			p_rgb += usize;
		}
	}

	#undef	__PIX_PM
}



void	pixmodel_rgb_set_v(
			void*		pixels,		/* Pixel buffer		*/
			float*		values,		/* New values 		*/
			int			count,		/* Items count		*/
			PXM_MODEL	model,		/* Pixel model		*/
			int			usize,		/* Pixel size, bytes*/
			float*		prev ) {	/* Current values	*/
	float		k;
	uint8_t*	p = (uint8_t*)pixels;

	#define	__PIX_INC	{p+=usize; values++; prev++; }

	if (model == PIXEL_HSV_VALUE) {
		while (count--) {
			k = values[0] / prev[0];
			p[0] = k * p[0];
			p[1] = k * p[1];
			p[2] = k * p[2];
			__PIX_INC;
		}
	} else
	if (model == PIXEL_HSL_LIGHTNESS ||
		model == PIXEL_BRIGHTNESS ||
		model == PIXEL_LUMA) {
		while (count--) {
			k = values[0] - prev[0];
			k/= 1.1 - prev[0];

			p[0] = (1 - k)*p[0] + 1.1*k*255;
			p[1] = (1 - k)*p[1] + 1.1*k*255;
			p[2] = (1 - k)*p[2] + 1.1*k*255;
			__PIX_INC;
		}
	} else
	if (model == PIXEL_GRAY_VALUE) {
		while (count--) {
			p[0] = values[0] * 255;
			__PIX_INC;		
		}
	} else {
		/* Unsupported opcode	*/
	}

	#undef	__PIX_INC
}


