/*_ GIMP DR Transformation plug-in.                 _*/
/*_ Copyright (c) 2007, Ivan Bezdomniy              _*/
/*_ This program is free software. It may be distributed
 * and/or modified under the terms of the General Public
 * License. See the GNU General Public License for more
 * details */


#include "config.h"

#include <libgimp/gimp.h>
#include <libgimp/gimpui.h>

#define	_PLUGIN_GUI_INTERNAL
#include "main.h"
#undef	_PLUGIN_GUI_INTERNAL
#include "render.h"

#include "plugin-intl.h"


extern  struct _Render_Control	o;
extern	PLUG_PARMS				plugs;


GtkWidget*	n_option(int, GtkWidget*, gint, gint,
					const gchar*, gdouble*);
void		option_get		(void);
void		preview_update	(GtkWidget*, void*);



/* Widgets		*/
GtkWidget*		f_radius;
GimpPreview*	w_preview;
GtkWidget*		w_size;
GtkWidget*		g_center;
GtkWidget*		g_uniformity;
GtkWidget*		g_edges;
GtkWidget*		g_contr;
GtkWidget*		g_width;
GtkWidget*		g_assymm;

/*_ Filter dialog routine			_*/
gboolean
  gui_dialog(PLUG_PARMS* data) {
	GtkWidget*	dialog;		/*_ Dialog				_*/
	GtkWidget*	vbox;		/*_ Top VBox			_*/
	GtkWidget*	table;
	gdouble		xres, yres;	/*_ Screen resolutuin	_*/
	GimpUnit	unit;		/*_ Default image unit	_*/

	f_radius	= NULL;
	w_preview	= NULL;
	w_size		= NULL;
	g_center	= NULL;
	g_uniformity		= NULL;
	g_edges		= NULL;
	g_width	= NULL;

	gimp_ui_init (PLUGIN_NAME, TRUE);

	/*_ Make dialog widget			_*/
	dialog = gimp_dialog_new (
			_("DR Transformer"),
			PLUGIN_NAME,
			NULL, 0,
			gimp_standard_help_func,
			"plug-in-drt",
			GTK_STOCK_CANCEL,
			GTK_RESPONSE_CANCEL,
			GTK_STOCK_OK,
			GTK_RESPONSE_OK,
			NULL);

	gtk_dialog_set_alternative_button_order(
		GTK_DIALOG (dialog),
        GTK_RESPONSE_OK,
		GTK_RESPONSE_CANCEL,
		-1);

	gimp_window_set_transient (GTK_WINDOW (dialog));

	/*_ Make master VBOX packer			_*/
	vbox = gtk_vbox_new (FALSE, 12);
	
	gtk_container_set_border_width (GTK_CONTAINER (vbox), 12);
	gtk_container_add (GTK_CONTAINER (GTK_DIALOG (dialog)->vbox), vbox);

	/*_ Make preview widget				_*/
	w_preview	= gimp_drawable_preview_new (o.workDrw, &plugs.preview);
	gtk_box_pack_start (GTK_BOX(vbox), w_preview, TRUE, TRUE, 0);

	g_signal_connect (
			w_preview, "invalidated",
			G_CALLBACK (preview_update),
			NULL);

	/*_ Make radius widget				_*/
	f_radius	= gimp_frame_new (_("Spot size"));

	unit = gimp_image_get_unit(o.imageID);
	gimp_image_get_resolution (o.imageID, &xres, &yres);

	w_size = gimp_coordinates_new (
				unit, "%a",
				TRUE, FALSE, -1,
				GIMP_SIZE_ENTRY_UPDATE_SIZE,
				(plugs.rX == plugs.rY),
				FALSE,
				_("_X:"), plugs.rX, xres,
				0, 8 * MAX (o.workDrw->width, o.workDrw->height),
				0, 0,
				_("_Y:"),   plugs.rY, yres,
				0, 8 * MAX (o.workDrw->width, o.workDrw->height),
				0, 0);

	gtk_container_set_border_width  (GTK_CONTAINER (w_size), 6);
	gimp_size_entry_set_pixel_digits(GIMP_SIZE_ENTRY (w_size), 1);
	gtk_container_add (GTK_CONTAINER(f_radius), w_size);
	gtk_box_pack_start(GTK_BOX (vbox), f_radius, TRUE, TRUE, 0);

	g_signal_connect_swapped (
			w_size, "value-changed",
			G_CALLBACK (gimp_preview_invalidate),
			w_preview);

	/*g_signal_connect_swapped (
			w_size, "refval-changed",
			G_CALLBACK (gimp_preview_invalidate),
			w_preview);
	*/
	/*_ Make options table			_*/
	table = gtk_table_new(3, 6, FALSE);
	gtk_table_set_col_spacings(GTK_TABLE (table), 6);
	gtk_table_set_row_spacings(GTK_TABLE (table), 6);
	gtk_box_pack_start (GTK_BOX(vbox), table, FALSE, FALSE, 0);


	/* Center value 				*/
	g_center = n_option(0, table, 0, 0, _("_Center"), &plugs.v_center);
	/* Unity value					*/
	g_uniformity  = n_option(0, table, 0, 1, _("_Uniformity"),  &plugs.v_uniformity);
	/* Edges regression				*/
	g_edges  = n_option(0, table, 0, 2, _("_Edges"),  &plugs.v_edges);
	/* Contrast transformation		*/
	g_contr  = n_option(1, table, 0, 3, _("_Contrast"),&plugs.v_contrast);
	/* Range widness factor			*/
	g_width= n_option(1, table, 0, 4, _("_Width"),&plugs.v_width);
	/* DR Assymmentry				*/
	g_assymm = n_option(1, table, 0, 5, _("_Asymmetry"),&plugs.v_assymm);

	/*_ Finaly, show all widgets	_*/
	gtk_widget_show_all(vbox);
	gtk_widget_show(dialog);


	/*_ Run dialog & wait			_*/
	if (gimp_dialog_run (GIMP_DIALOG (dialog)) == GTK_RESPONSE_OK) {
		/*_ Save params & exit			_*/
		option_get();
		gtk_widget_destroy (dialog);
		return TRUE;
	} else {
		gtk_widget_destroy (dialog);
		return FALSE;
	}
}



/*_ Add an option widget		_*/
GtkWidget*	n_option(
				int				type,
				GtkWidget*		table,
				gint			pX,
				gint			pY,
				const gchar*	name,
				gdouble*		value) {
	GtkWidget*	_r;

	/*_ Add options to the table	_*/
	#define	O_PACK(_mn, _mx){ \
		_r = gimp_scale_entry_new(					\
			GTK_TABLE(table), pX, pY, _(name),		\
			100, 5, *value, _mn, _mx, 0.01, 0.01, 2,\
			TRUE, 0, 0, NULL, NULL);  }

	if (type == 0) {
		/* Asymmetric option		*/
		O_PACK(0.0, 1.0);
	} else
	if (type == 1) {
		/* Symmetric option			*/
		O_PACK(-1.0, 1.0);
	} else
		return NULL;

	g_signal_connect(
			_r, "value-changed",
			G_CALLBACK (gimp_double_adjustment_update),
			(void*)value);

	g_signal_connect_swapped (
			_r, "value-changed",
			G_CALLBACK (gimp_preview_invalidate),
			w_preview);


	return _r;	
}



/*_ Getoptions from widgets		_*/
void	option_get (void) {
	/* Get tone blur radius		*/
	plugs.rX = gimp_size_entry_get_refval (GIMP_SIZE_ENTRY (w_size), 0);
	plugs.rY = gimp_size_entry_get_refval (GIMP_SIZE_ENTRY (w_size), 1);

	/* Get options				*/
	/* Other options are autoupdated*/
}



/*_ Preview image update		_*/
void
	preview_update(
			GtkWidget*		widget,
			void*			data) {
	if (!plugs.preview) return ;
	/* Retrive options				*/
	option_get();

	/* Fill preview rect			*/
	gimp_preview_get_position (w_preview, &o.rP.x1, &o.rP.y1);
	gimp_preview_get_size     (w_preview, &o.rP.x2, &o.rP.y2);

	o.rP.x2 += o.rP.x1;
	o.rP.y2 += o.rP.y1;

	/* Reconfigure engine			*/
	if(!r_execute(&plugs, (void*)widget)) return;

	gimp_drawable_preview_draw_region(
			GIMP_DRAWABLE_PREVIEW (w_preview),
			&o.rPrv);
}


