/*_ GIMP DR Transformation plug-in.					_*/
/*_ Copyright (c) 2007, Ivan Bezdomniy				_*/
/*_ This program is free software. It may be distributed
 * and/or modified under the terms of the General Public
 * License. See the GNU General Public License for more
 * details */


#include "config.h"

#include <string.h>

#include <libgimp/gimp.h>
#include <libgimp/gimpui.h>

#define	_PLUGIN_GUI_INTERNAL
#include "main.h"
#undef	_PLUGIN_GUI_INTERNAL
#include "render.h"

#include "plugin-intl.h"


/*_  Constants					_*/
#define PROCEDURE_NAME   "gimp_plugin_drt"
#define DATA_KEY_VALS    "plug_in_drt"
#define DATA_KEY_UI_VALS "plug_in_drt_ui"
#define PARASITE_KEY     "plug-in-drt-options"



/*_ Local function prototypes	_*/

static void   query (void);
static void   run   (const gchar      *name,
		     gint              nparams,
		     const GimpParam  *param,
		     gint             *nreturn_vals,
		     GimpParam       **return_vals);


/*_ PLugin defaults setting			_*/
PLUG_PARMS plugs = {
	1,		/* Default is no preview*/
	24,		/* x-radius				*/
	24,		/* y-radius				*/
	0.6,	/* Center point value	*/
	0.7,	/* Unity step			*/
	0.4,	/* Edges soft			*/
	0.0,	/* Contrast value		*/
	0.0,	/* DR Widness factor	*/
	0.0		/* DR Assymmetry factor	*/
};


/*_ Plug-in info structure		_*/
const GimpPlugInInfo PLUG_IN_INFO = {
	NULL,  /* init_proc  */
	NULL,  /* quit_proc  */
	query, /* query_proc */
	run,   /* run_proc   */
};


MAIN ()

/*_ GIMP'S Query interface call _*/
static void
	query (void) {
	
	static GimpParamDef args[] = {
		{ GIMP_PDB_INT32,    "run-mode", "Interactive, non-interactive" },
		{ GIMP_PDB_IMAGE,    "image",    "Input image (unused)"         },
		{ GIMP_PDB_DRAWABLE, "drawable", "Input drawable"               },
		{ GIMP_PDB_FLOAT,	 "center",	 "Center value"					},
		{ GIMP_PDB_FLOAT,	 "uniformity",	"Tone map uniformity"		},
		{ GIMP_PDB_FLOAT,	 "edges",	 "Edges DR regression"			},
		{ GIMP_PDB_FLOAT,	 "contrast", "Adaptive contrast value"		},
		{ GIMP_PDB_FLOAT,	 "width",	 "DR width factor"				},
		{ GIMP_PDB_FLOAT,	 "asymmetry","Tone mapping asymmetry"		}
	};

	gimp_plugin_domain_register (PLUGIN_NAME, LOCALEDIR);

	gimp_install_procedure (
		PROCEDURE_NAME,
		N_("Dynamic Range Transformer"),
		"Transforms an image DR",
		"Ivan Bezdomniy <bezdomniy@gmail.com>",
		"Ivan Bezdomniy <bezdomniy@gmail.com>",
		"2007",
		N_("Dynamic Range Transformer"),
		"RGB*, GRAY*",
		GIMP_PLUGIN,
		G_N_ELEMENTS (args), 0,
		args, NULL);

	gimp_plugin_menu_register (PROCEDURE_NAME, "<Image>/Filters/Enhance");
}



/*_ GIMP's plug-in entry point _*/
static void
	run (const gchar      *name,
    	 gint              nparams,
    	 const GimpParam  *param,
    	 gint             *nreturn_vals,
    	 GimpParam       **return_vals) {
	//gint32				iID;
	GimpPDBStatusType	status = GIMP_PDB_SUCCESS;
	static GimpParam	values[1];
	int					flags =  0;

	/*_  Initialize i18n support	_*/
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
#ifdef HAVE_BIND_TEXTDOMAIN_CODESET
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
#endif
	textdomain (GETTEXT_PACKAGE);

	values[0].type          = GIMP_PDB_STATUS;
	values[0].data.d_status = status;

	*nreturn_vals = 1;
	*return_vals  = values;

	r_reset();

	if (strcmp (name, PROCEDURE_NAME) != 0 || nparams < 3) {
		status = GIMP_PDB_CALLING_ERROR;
		goto exit;
	}

	switch(param[0].data.d_int32) {
		case GIMP_RUN_INTERACTIVE:
			flags |= R_INIT_INTERACTIVE;
			flags |= R_INIT_RESTOREVALS;
			break;

		case GIMP_RUN_WITH_LAST_VALS:
			flags |= R_INIT_RESTOREVALS;
			break;

		case GIMP_RUN_NONINTERACTIVE:
			if (nparams != 9) {
				status = GIMP_PDB_CALLING_ERROR;
				goto exit;
			}

			plugs.preview 	= 0;
			plugs.v_center	= param[3].data.d_float;
			plugs.v_uniformity 	= param[4].data.d_float;
			plugs.v_edges 	= param[5].data.d_float;
			plugs.v_contrast= param[6].data.d_float;
			plugs.v_width	= param[7].data.d_float;
			plugs.v_assymm	= param[8].data.d_float;
			break;
	}



	if(!r_init(
			param[1].data.d_image,
			param[2].data.d_drawable,
			flags) ) {
		g_debug("Can't init engine");
		goto exit;
	}

	if (flags & R_INIT_RESTOREVALS)
		gimp_get_data(PROCEDURE_NAME, &plugs);

	if (flags & R_INIT_INTERACTIVE) {
		if (!gui_dialog(&plugs)) goto exit;
		gimp_set_data(PROCEDURE_NAME,&plugs,sizeof(PLUG_PARMS));
	} 

	r_execute(&plugs, NULL);

	if (flags & R_INIT_INTERACTIVE) {
		gimp_displays_flush ();
	}

exit:
	r_clean();

	values[0].data.d_status = status;
}



