/*_ GIMP DR Transformation plug-in.                 _*/
/*_ Copyright (c) 2007, Ivan Bezdomniy              _*/
/*_ This program is free software. It may be distributed
 * and/or modified under the terms of the General Public
 * License. See the GNU General Public License for more
 * details */


#ifndef __PLUGIN_UNIFY_RENDER
#define __PLUGIN_UNIFY_RENDER

#include <magie/offimage.h>
#include <magie/pixmodel.h>
#include <magie/drconv.h>


/* Some constants		*/
#define	R_INIT_INTERACTIVE		0x01
#define	R_INIT_RESTOREVALS		0x02
#define	R_LIMIT_ERRORS			0x10	/* Errors limit		*/

/* Rect. structure defintion	*/
struct	_P_Rect {
	gint		x1, y1;		/* Left-up point	*/
	gint		x2, y2;		/* Right-down point	*/
};


/*_ Render control object		_*/
struct _Render_Control{
/*_ Control flags				_*/
	struct {
		int	is_gray			:1;	/* Pixel is "grayscale"		*/
		int	is_rgb			:1;	/* Pixel model is RGB		*/
		int	is_alpha		:1;	/* Image has alpha channel	*/
		int	off_im_valid	:1;	/* Offline images are valid */
		int	is_configured	:1; /* Engine configured		*/
		int	is_preview		:1;	/* Preview					*/
		int	is_interactive	:1;	/* Interactive mode			*/

	};

/*_ Image params		_*/
	gint32			imageID;
	gint32			workID;
	GimpDrawable*	workDrw;
	GimpPixelRgn	rSrc;	/* Source region			*/
	GimpPixelRgn	rDst;	/* Destination p.region		*/
	GimpPixelRgn	rPrv;	/* Preview region			*/
	GimpPixelRgn*	rOut;	/* Output region to use		*/
	gint			sX;		/* X image size				*/
	gint			sY;		/* Y image size				*/
	gint			bpp;	/* bytes per pixel			*/
/*_ Selection bounds	_*/
	struct _P_Rect	rM;		/* Mask rect				*/
	struct _P_Rect	rP;		/* Preview rect				*/
	struct _P_Rect*	rU;		/* Rect to use				*/
/*_ Filter settings		_*/
	gint			rX, rY;	/* Blur X/Y radius			*/
/*_ DRE engine objects	_*/
	OFFIMAGE		o_avg;
	OFFIMAGE		o_sqr;
	PXM_MODEL		model;	/* Pixel model conversion	*/
	DRC_OBJ			vmp;	/* V_Mapper control object	*/
};



/*_ Render interface			_*/
void		r_reset		(void);
gboolean	r_init		(gint32, gint32, int);
gboolean	r_execute	(PLUG_PARMS*, void*);
void		r_clean		(void);

#endif/*__PLUGIN_UNIFY_RENDER */


#ifdef	__RENDER_INTERNAL

/*_ Progress status definition	_*/

/* Constants			*/
#define	_PRGS_GRANULAR	100		/* 100 items granularity*/
#define	_PRGS_MIN_DIV	0x08
#define	_PRGS_STAGES	0x02	/* Stages count			*/
/* Status texts			*/
#define	_PRGS_T_DRCM	_("DRT Execution")
#define	_PRGS_T_DRCI	_("DRT: Init")
#define	_PRGS_T_DRCT	_("DRT: Building tone maps")
#define	_PRGS_T_DRCU	_("DRT: Applying conversion")
/* Progress opcodes		*/
#define	_PRGS_INIT		0x01
#define	_PRGS_FIN		0x02
#define	_PRGS_ENTER		0x03
#define	_PRGS_LEAVE		0x04
#define	_PRGS_UPDATE	0x05
/* Stages definitions	*/
#define	_PRGS_STG_01	0x01	/* Build tone map stage	*/
#define	_PRGS_STG_02	0x02	/* DRC conveyer stage	*/
#define	_PRGS_STAGESM	(_PRGS_STG_01|_PRGS_STG_02)


struct	_Progress_Status {
	int		mask;				/* Stages mask		*/
	int		stage;				/* Current stage	*/
	int		weight_summ;		/* Total weight		*/
	int		weight_cur;			/* Current weght	*/
	int		weight_step;		/* One step weight	*/
	int		weight[_PRGS_STAGES];		
	int		accum;				/* Accumulator		*/

};


/*_ Render internal calls		_*/
int			r_value		(void);
int			i_oi_blur	(OFFIMAGE*, OFFISTATE*, int, int, int);
int		 	r_unify		(void);
int			r_progress	(int, int);

#endif/*__RENDER_INTERNAL*/



