#!/usr/bin/env python
# Studio Tecnico Arch. Giuseppe Conte  
# via Roma, 28
# 72026 - San Pancrazio Salentino (BR) - Italy
#
# Plugin  : make_gradient.py
# Author  : Arch. Giuseppe Conte 
# Date    : 14 luglio 2008 
# Revision: 
# Version : 2.0
# Last version at: http://xoomer.alice.it/lwcon/gimp/
# Help guide at  : http://xoomer.alice.it/lwcon/python/py_make_gradient.htm
#
# Dependencie: 
# Download   : http://xoomer.alice.it/lwcon/gimp/python/py_make_gradient.htm
#
# Description: 
# Make gradient from active image.

# -----------------------------------------------------------------------------
#
# License:
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
# -----------------------------------------------------------------------------
#

from gimpfu import *
import os # needed to manipulate the filename

global slash
sist_op=os.name
if sist_op=="nt":
    slash="\\"
else:
    slash="/"

def make_gradient(img, drawable,folder,numSegment,gtype):

    path=os.path.dirname(folder)+slash
    tmp = os.path.split(folder)
    filename = tmp[1]
    gradientname = filename[:-4]
    name_img=pdb.gimp_image_get_name(img)
    name_img=name_img[:-4]
    #verifica la presenza di un canale alfa, se assente lo aggiunge
    if (pdb.gimp_drawable_has_alpha(drawable) == FALSE):
      pdb.gimp_layer_add_alpha(drawable)

    height = pdb.gimp_image_height(img)
    width = pdb.gimp_image_width(img)
    nfa = open(folder, 'w')
    #scrittura su file intestazione
    tmp = "GIMP Gradient" + "\n"
    nfa.write(tmp)
    tmp = "Name: " + gradientname + "\n"
    nfa.write(tmp)
    nfa.write(str(numSegment) + "\n")
    # fine intestazione
    x = 0
    y = 0
    px = 0
    passo = round((1.0 / numSegment), 6)
    seg_right = 0.000000
    
    while (px < numSegment):
      #pixel = pdb.gimp_drawable_get_pixel(drawable, x, y)

      seg_left = seg_right
      seg_middle = seg_left + (passo / 2)
      seg_right = seg_left + passo
      if (px == (numSegment - 1)):
        seg_right = 1.000000

      pixel = pdb.gimp_drawable_get_pixel(drawable, x, y)      
      value = pixel[1]
      red = value[0]
      green = value[1]
      blue = value[2]
      alfa = value[3]
      
      seg_r0 = round((red / 255.0), 6)
      seg_g0 = round((green / 255.0), 6)
      seg_b0 = round((blue / 255.0), 6)
      seg_a0 = round((alfa / 255.0), 6)

      pixel = pdb.gimp_drawable_get_pixel(drawable, x+1, y)
      value = pixel[1]
      red = value[0]
      green = value[1]
      blue = value[2]
      alfa = value[3]
      
      seg_r1 = round((red / 255.0), 6)
      seg_g1 = round((green / 255.0), 6) 
      seg_b1 = round((blue / 255.0), 6) 
      seg_a1 = round((alfa / 255.0), 6)
      
      seg_type = 0
      seg_color = 0

      esared = "%02x" % red
      esagreen = "%02x" % green
      esablue = "%02x" % blue
      tmp1 = str(seg_left) + " " + str(seg_middle) + " " + str(seg_right) + " "
      tmp2 = str(seg_r0) + " " + str(seg_g0) + " " + str(seg_b0) + " " + str(seg_a0) + " "
      tmp3 = str(seg_r1) + " " + str(seg_g1) + " " + str(seg_b1) + " " + str(seg_a1) + " "
      tmp = tmp1 + tmp2 + tmp3 + str(seg_type) + " " + str(seg_color) + "\n"
      nfa.write(tmp)
      
      px = px + 1
      x = x + 2
      if (x == width):
        x = 0
        y = y + 1

    nfa.close()
    

register (
    "py_make_gradient",
    "Make gradient from active image",
    "Make gradient from active image",
    "Giuseppe Conte",
    "Giuseppe Conte",
    "2008",
    "<Image>/Python-Fu/ATG/Make Gradient...",
    "",
    [
    (PF_FILE, "folder", "Path to store new gradient", os.getcwd()),    
    (PF_INT, "numSegment", "Numero Segmenti", 3), 
    (PF_RADIO, "gtype", ("Gradient Type:"), "medium", (("None","none"), ("Fine","fine"), ("Medium", "medium"), ("Coarse", "coarse"))),
    ],
    [],
    make_gradient)

main ()


