#!/usr/bin/env python

'''
  A GIMP plugin.
  Make shortcut...
  Generates another plugin (in Python language) that is a shortcut to a target plugin.
  Shortcut means: 
  1) alias or link to target plugin
  2) no options dialog (standard, current, or preset options for the target plugin.)

  Copyright (C) 2010 Lloyd Konneker      bootch at nc.rr.com

  Installation:

    cp plugin-make-shortcut.py ~/.gimp-2.6/plug-ins (user's local directory)
    chmod +x ~/.gimp-2.6/plug-ins/plugin-make-shortcut.py
    cp -r make-shortcut ~/.gimp-2.6/plug-ins
    (copy the make-shortcut directory which comprises .glade and .py files)
    
  This is the help text, copied from makeshortcut.glade:
  Choose a plugin and enter a name for a shortcut to it.  
  Shortcuts do not appear until you restart GIMP.
  Shortcuts use the standard or current options of the plugin and do not present an options dialog.
  Shortcuts are enabled according to the mode of the image (e.g. RGB or Grayscale.)
  Plugins without sensible defaults are not suitable for shortcuts.
  You can remove shortcuts by deleting their files (e.g. plugin-shortcut-to-foo.py) 
  in your plugin directory.
  
    
  License:
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
    
'''



'''
To Be Done

More functionality:
  presets: let user enter parameters for target plugin.  Use gimpfu GUI functions?

User friendliness:
  gui non-modal: Apply/Quit
  let user root shortcuts elsewhere in menu tree
  domain i8n
  check if menu item already used?
  Since the menu item is not the same as the filename?
  check if the filename already used
  tell the user we created it but GIMP restart required
  and don't show that message more than once.
  Disallow making shortcut to shortcut?
  Disallow making shortcut to Load/Save?
  Return key in name text entry Apply
  
Done:
  shortcuts to plugins independent of image, without parameters
'''


from gimpfu import * 


def plugin_main():
    import makeshortcut.gui
    
    # Build data that drives the app: dictionary of views on dbs
    # For each kind of db, import the glue module to the db
    # and get the dictofviews from the glue module.
    
    # Here, there is only one view, a treeview on GIMP plugins.
    import makeshortcut.plugindb # glue to the Gimp PDB
    dictofviews = makeshortcut.plugindb.dictofviews.copy()
    
    app = makeshortcut.gui.MakeShortcutApp(dictofviews)  # create instance of gtkBuilder app
    app.main()  # event loop for app
    print "Shortcut created"



if __name__ == "__main__":
    # if invoked from Gimp app as a plugin

    register(
        "python_fu_make_shortcut",
        "Make a shortcut to another plugin.",
        "This plugin creates another menu item, a shortcut to a target plugin.  The shortcut executes the target with its current options (without a dialog.)",
        "Lloyd Konneker (bootch nc.rr.com)",
        "Copyright 2010 Lloyd Konneker",
        "2010",
        "_Make shortcut...",
        "", # image types: blank means don't care but no image param
        [],
        [],
        plugin_main,
        menu="<Image>/Filters/")
        # This is really the menupath, the menuitem is prior
        # !!! But note no parameters are passed.
        
        # domain=("gimp20-python", gimp.locale_directory))
    
    print "Starting plugin-make-shortcut"
    main()




