#!/usr/bin/env python
# Studio Tecnico Arch. Giuseppe Conte  
# via Roma, 28
# 72026 - San Pancrazio Salentino (BR) - Italy
#
# Plugin  : palette-to-textile.py
# Author  : Arch. Giuseppe Conte 
# Date    : 18 giugno 2009 
# Revision: 
# Version : 1.0
# Last version at: http://xoomer.alice.it/lwcon/gimp/python/palette-to-textile.htm
# Help guide at  : http://xoomer.alice.it/lwcon/gimp/python/palette-to-textile.htm
#
# Dependencie: 
# Download   : http://xoomer.alice.it/lwcon/gimp/python/palette-to-textile.htm
#
# Description: 
# To create seamless image of one the woven from palette.

# -----------------------------------------------------------------------------
#
# License:
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
# -----------------------------------------------------------------------------
#

from gimpfu import *

gettext.install("gimp20-python", gimp.locale_directory, unicode=True)


def palette_to_textile(height, width, palette):
    num_colors = pdb.gimp_palette_get_info(palette)
    num_segments = num_colors - 1
    #inizio procedura
    gradient = pdb.gimp_gradient_new("ATGtemp")
    pdb.gimp_gradient_segment_range_split_uniform(gradient, 0, -1, num_segments)

    for color_number in range(0,num_segments):
        if (color_number == num_colors-1):color_number_next = 0
        else: color_number_next = color_number + 1
        color_left = pdb.gimp_palette_entry_get_color(palette, color_number)
        color_right = pdb.gimp_palette_entry_get_color(palette, color_number_next)
        pdb.gimp_gradient_segment_set_left_color(gradient, color_number, color_left, 100.0)
        pdb.gimp_gradient_segment_set_right_color(gradient, color_number, color_right, 100.0)
    pdb.gimp_context_set_gradient(gradient)
    #fine procedura
    image = pdb.gimp_image_new(width, height, RGB)
    layer = pdb.gimp_layer_new(image, width, height, RGBA_IMAGE, "ATG_0", 100, NORMAL_MODE)
    pdb.gimp_image_add_layer(image, layer, -1)
    idImage = pdb.gimp_display_new(image)
    pdb.gimp_displays_flush()
    pdb.gimp_edit_blend(layer, CUSTOM_MODE, NORMAL_MODE, GRADIENT_SEGMENT_LINEAR, 100, 0, REPEAT_NONE, FALSE, FALSE, 3, 1, TRUE, 0, 0, width, 0)
    layer2 = pdb.gimp_layer_new(image, width, height, RGBA_IMAGE, "ATG_1", 50, NORMAL_MODE)
    pdb.gimp_image_add_layer(image, layer2, -1)
    pdb.gimp_displays_flush()
    pdb.gimp_edit_blend(layer2, CUSTOM_MODE, NORMAL_MODE, GRADIENT_SEGMENT_LINEAR, 50, 0, REPEAT_NONE, FALSE, FALSE, 3, 1, TRUE, 0, 0, 0, height)
    pdb.gimp_gradient_delete(gradient)
    newlayer = pdb.gimp_image_flatten(image)


register(
    "python-fu-palette-to-textile",
    N_("Create a seamless image using colors from the palette"),
    "Create a new textile image using colors from the palette.",
    "Conte Giuseppe",
    "Conte Giuseppe",
    "2009",
    N_("Palette to _Textile"),
    "",
    [(PF_INT, "height", "Height", 200),
     (PF_INT, "width", "Width", 200),
     (PF_PALETTE,  "palette", _("Palette"), "")],
    [(PF_GRADIENT, "new-gradient", "Result")],
    palette_to_textile,
    menu="<Image>/Python-Fu/ATG/",
    domain=("gimp20-python", gimp.locale_directory)
    )

main ()
