#ifndef HEADERS_H
#define HEADERS_H

#ifdef _MSC_VER
/* Microsoft Visual C */
#define HAVE_SYS_TYPES_H 1
#define HAVE_SYS_STAT_H 1
#define STDC_HEADERS 1
#define HAVE_STRING_H 1
#define HAVE_MALLOC_H 1
#define HAVE_SETJMP_H 1
#define GETTEXT_PACKAGE "pds"
#define LOCALEDIR "po"
#define PLUGIN_VERSION "2.3.5"
#define PLUGIN_NAME "pds"
typedef long off_t;
#else
/* GNU autoconf */
#include "config.h"
#endif

#include <stdio.h>
#if HAVE_SYS_TYPES_H
# include <sys/types.h>
#endif
#if HAVE_SYS_STAT_H
# include <sys/stat.h>
#endif
#if STDC_HEADERS
# include <stdlib.h>
# include <stddef.h>
#else
# if HAVE_STDLIB_H
#  include <stdlib.h>
# endif
#endif
#if HAVE_STRING_H
# if !STDC_HEADERS && HAVE_MEMORY_H
#  include <memory.h>
# endif
# include <string.h>
#endif
#if HAVE_STRINGS_H
# include <strings.h>
#endif
#if HAVE_INTTYPES_H
# include <inttypes.h>
#else
# if HAVE_STDINT_H
#  include <stdint.h>
# endif
#endif
# if HAVE_MALLOC_H
#  include <malloc.h>
#endif
# if HAVE_SETJMP_H
#  include <setjmp.h>
#endif

#ifdef HAVE_UNISTD_H
# include <unistd.h>
#define casecmp(a,b) strcasecmp((a),(b))
#else
/* Non-Unix */
#include <io.h>
#include <process.h>
#define casecmp(a,b) stricmp((a),(b))
#endif
#endif

