;;; Studio Tecnico Arch. Giuseppe Conte  
;;; via Roma, 28
;;; 72026 - San Pancrazio Salentino (BR) - Italy
;;;
;;; Plugin  : pencil-drawing-from-photo.scm
;;; Author  : Arch. Giuseppe Conte 
;;; Date    : 30 ottobre 2008 -  San Pancrazio Salentino - Italy
;;; Revision: Scripfu create for GIMP 2.6
;;; 					
;;; Version : 1.0
;;; Last version at: http://xoomer.alice.it/lwcon/gimp/script-fu/pencil-drawing-from-photo.htm
;;; Help guide at  : http://xoomer.alice.it/lwcon/gimp/script-fu/pencil-drawing-from-photo.htm
;;; Required : Gimp 2.0 or last
;;;
;;; Description: 
;;; To create pencil drawing from photographic image.
;;; Based on the Tutorial: Making a pencil drawing from a photo, 
;;; written by devv: http://www.gimpusers.com/users/devvv.html
;;; -----------------------------------------------------------------------------
;;;
;;; License:
;;; This program is free software; you can redistribute it and/or modify
;;; it under the terms of the GNU General Public License as published by
;;; the Free Software Foundation; either version 2 of the License, or
;;; (at your option) any later version.
;;; 
;;; This program is distributed in the hope that it will be useful,
;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;; GNU General Public License for more details.
;;; 
;;; You should have received a copy of the GNU General Public License
;;; along with this program; if not, write to the Free Software
;;; Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

;;; Define the function:

(define (script-fu-pencil-drawing-from-photo inImage inLayer iterazioni optMarcatura rilevaContorni)
	(let* ( (new-layer 0)
					(firstcopy-layer 0)
					(secondcopy-layer 0)
					(merged-layer 0)
					(cnt 1)
				)
	;duplicate background layer
	(set! new-layer (car (gimp-layer-copy inLayer TRUE)))
	(gimp-image-add-layer inImage new-layer -1)

	;remove color -> set saturation -100
	(gimp-hue-saturation new-layer ALL-HUES 0 0 -100)

	;duplicate background layer
	(set! firstcopy-layer (car (gimp-layer-copy new-layer TRUE)))
	(gimp-image-add-layer inImage firstcopy-layer -1)	
	(plug-in-sel-gauss -1 inImage firstcopy-layer 4 50)
	(gimp-invert firstcopy-layer)
	(gimp-layer-set-opacity firstcopy-layer 50)
	(set! secondcopy-layer (car (gimp-image-merge-down inImage firstcopy-layer 0)))
	
	(set! new-layer (car (gimp-layer-copy secondcopy-layer TRUE)))
	(gimp-image-add-layer inImage new-layer -1)	
	(gimp-layer-set-mode new-layer DODGE-MODE)
	
	(cond 
				((= optMarcatura TRUE)
					;reitera
					(set! merged-layer (car (gimp-image-merge-down inImage new-layer 0)))	
					(set! firstcopy-layer (car (gimp-layer-copy merged-layer TRUE)))	
					(gimp-image-add-layer inImage firstcopy-layer -1)	
					(gimp-layer-set-mode firstcopy-layer MULTIPLY)
				)
	);cond
	
	;flatten image
	(set! new-layer (car (gimp-image-flatten inImage)))
	(plug-in-unsharp-mask -1 inImage new-layer 5 0.5 0) 

	;applica iterativamente una maschera di contrasto per esaltarne i contorni
	(while (< cnt iterazioni)
		(plug-in-unsharp-mask -1 inImage new-layer 5 1 5)
		(set! cnt (+ cnt 1))
	);end while

	;RILEVAMENTO contorni
	(cond 
				((= rilevaContorni TRUE)
					(plug-in-edge -1 inImage new-layer 2 2 0)	
					(plug-in-vinvert -1 inImage new-layer) 
				)
	);cond	
	
	;; continuare da qui
  ;(gimp-edit-fill inLayer 0)		    

  (gimp-displays-flush)
	);let
);def

(script-fu-register
 "script-fu-pencil-drawing-from-photo"
 _"<Image>/_ATG/Trasforma/Pencil drawing .."
"To create pencil drawing from photographic image."
 "Arch. Giuseppe Conte"
 "2008, Giuseppe Conte"
 "30 ottobre 2008"
 "RGB* GRAY* INDEXED*"
 SF-IMAGE "The Image" 0
 SF-DRAWABLE "The Layer" 0
 SF-ADJUSTMENT "Iterations" '(3 0 9999 1 10 0 1)
 SF-TOGGLE     "Shading" FALSE
 SF-TOGGLE     "Edges" TRUE 
)