/* 
 * Poisson noise GIMP plugin
 * 
 * plugin.c
 * Copyright 2008 by Marco Rossini
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2+
 * as published by the Free Software Foundation.
 */

#include "plugin.h"

GimpPlugInInfo PLUG_IN_INFO = { NULL, NULL, query, run };

MAIN ()
     void query (void)
{
  static GimpParamDef args[] = {
    {GIMP_PDB_INT32, "run-mode", "Run mode"},
    {GIMP_PDB_IMAGE, "image", "Input image"},
    {GIMP_PDB_DRAWABLE, "drawable", "Input drawable"},
    {GIMP_PDB_INT8, "photons", "Number of photons"}
  };

  gimp_install_procedure ("plug-in-poisson-noise",
			  N_("Generates Poisson noise."),
			  "Generates Poisson noise.",
			  "Marco Rossini",
			  "Copyright 2008 Marco Rossini",
			  "2008",
			  N_("_Poisson noise ..."),
			  "RGB*, GRAY*",
			  GIMP_PLUGIN, G_N_ELEMENTS (args), 0, args, NULL);

  gimp_plugin_domain_register("gimp20-poisson-noise-plug-in", LOCALEDIR);

  gimp_plugin_menu_register ("plug-in-poisson-noise",
			     "<Image>/Filters/Noise/");
}

poisson_settings settings = {
  1,				/* photons */
  TRUE,				/* luminance_only */
  TRUE,				/* show_preview */
  -1, -1			/* winxsize, winysize */
};

void
run (const gchar * name, gint nparams, const GimpParam * param,
     gint * nreturn_vals, GimpParam ** return_vals)
{
  static GimpParam values[1];
  GimpRunMode run_mode;
  GimpDrawable *drawable;

  bindtextdomain("gimp20-poisson-noise-plug-in", LOCALEDIR);
  textdomain("gimp20-poisson-noise-plug-in");
  bind_textdomain_codeset("gimp20-poisson-noise-plug-in", "UTF-8");

  /* Setting mandatory output values */
  *nreturn_vals = 1;
  *return_vals = values;
  values[0].type = GIMP_PDB_STATUS;
  values[0].data.d_status = GIMP_PDB_SUCCESS;

  /* restore settings saved in GIMP core */
  gimp_get_data ("plug-in-poisson-noise", &settings);

  drawable = gimp_drawable_get (param[2].data.d_drawable);
  channels = gimp_drawable_bpp (drawable->drawable_id);

  /* run GUI if in interactiv mode */
  run_mode = param[0].data.d_int32;
  if (run_mode == GIMP_RUN_INTERACTIVE)
    {
      if (!user_interface (drawable))
	{
	  gimp_drawable_detach (drawable);
	  /* FIXME: should return error status here */
	  return;
	}
    }
  else
    {
      if (nparams == 4)
        {
	  settings.photons = param[3].data.d_int8;
	  if (settings.photons < 1 || settings.photons > 10) {
	    gimp_drawable_detach (drawable);
	    /* FIXME: should return error status here */
	    return;
	  }
        }
    }

  noise_gen (drawable, NULL);

  gimp_displays_flush ();
  gimp_drawable_detach (drawable);

  /* save settings in the GIMP core */
  gimp_set_data ("plug-in-poisson-noise", &settings,
		 sizeof (poisson_settings));
}
