/* 
 * Poisson noise GIMP plugin
 * 
 * plugin.h
 * Copyright 2008 by Marco Rossini
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2+
 * as published by the Free Software Foundation.
 */

#ifndef __PLUGIN_H__
#define __PLUGIN_H__

#include <stdlib.h>
#include <math.h>
#include <libgimp/gimp.h>
#include <libgimp/gimpui.h>
#include <libintl.h>
#include <locale.h>

#define LOCALEDIR "/usr/share/locale/"

#define _(string) gettext(string)
#define N_(string) string

#define MAX2(x,y) ((x) > (y) ? (x) : (y))
#define MIN2(x,y) ((x) < (y) ? (x) : (y))
#define CLIP(x,min,max) MAX2((min), MIN2((x), (max)))

/* Tool-tips */
#define TT_PHOTON _("Poisson noise arises from photon counting. This value determines the number of photons required to increase the pixel value by one. The higher the value the less noisy the result and the longer the processing time.")
#define TT_LUMINANCE _("Adds noise to the luminance (YCbCr) channel only. This also reduces processing time.")
#define TT_RESET _("Resets to the default values.")

void query (void);
void run (const gchar * name, gint nparams, const GimpParam * param,
		 gint * nreturn_vals, GimpParam ** return_vals);
void noise_gen (GimpDrawable * drawable, GimpPreview * preview);
void set_ycbcr_mode (GtkWidget * w, gpointer data);
void set_amount (GtkWidget * w, gpointer data);
void set_radius (GtkWidget * w, gpointer data);
gboolean user_interface (GimpDrawable * drawable);
void reset_channel (GtkWidget * w, gpointer data);
void rgb2ycbcr(float * r, float * g, float * b);
void ycbcr2rgb(float * y, float * cb, float * cr);

extern GimpPlugInInfo PLUG_IN_INFO;

typedef struct
{
  guint photons;
  gboolean luminance_only;
  gboolean show_preview;
  gint winxsize, winysize;
} poisson_settings;

extern poisson_settings settings;

gint channels;

#endif /* __PLUGIN_H__ */
