;Ray Studio v0.2
;
;Ray Studio - скрипт создания эффекта лучистого свечения;
;
;История версий:
;==================================================================
;ver. 0.2 (27 ноября 2011)
; - официальный выпуск;
;==================================================================

;script-fu-ray-studio
;Главная функция
;СПИСОК АРГУМЕНТОВ:
;IMAGE - обрабатываемое изображение;
;LAYER - обрабатываемый слой;
;FLOAT - граница отсечения яркости для лучей;
;COLOR - цвет тонировки луча;
;FLOAT - степень тонировки луча цветом;
;INTEGER - координата X для центра луча;
;INTEGER - координата Y для центра луча;
;INTEGER - величина размытия (длина луча);
;INTEGER - степень снижения разрешения;
(define (script-fu-ray-studio image layer ray_edge ray_color ray_color_opc x_axis y_axis blur_factor blur_degd)

  (let* (
	(org_imh (car (gimp-image-height image)))
	(org_imw (car (gimp-image-width image)))
	(degd_values (list 1 2 4 8 16))
	(fx_imh (/ org_imh (list-ref degd_values blur_degd)))
	(fx_imw (/ org_imw (list-ref degd_values blur_degd)))
	(ref_x_axis (/ x_axis (list-ref degd_values blur_degd)))
	(ref_y_axis (/ y_axis (list-ref degd_values blur_degd)))
	(fximage (car (gimp-image-new org_imw org_imh 0)))
	(fxlayer (car (gimp-layer-new-from-drawable layer fximage)))
	(reslayer)
	(colorlayer)
	(rotated FALSE)
	(fore (car (gimp-context-get-foreground)))
	)

	(gimp-image-undo-group-start image)
	(gimp-image-undo-disable fximage)

	(gel-image-insert-layer fximage fxlayer -1)
	(if (> blur_degd 0)
	  (gel-image-scale-full fximage fx_imw fx_imh 2)
	)
	(if (or (< ref_x_axis 0) (< ref_y_axis 0))
	  (begin
	    (set! rotated TRUE)
	    (gimp-image-rotate fximage 1)
	    (if (< ref_x_axis 0)
	      (set! ref_x_axis (+ (- 0 ref_x_axis) fx_imw))
	      (set! ref_x_axis (- fx_imw ref_x_axis))
	    )
	    (if (< ref_y_axis 0)
	      (set! ref_y_axis (+ (- 0 ref_y_axis) fx_imh))
	      (set! ref_y_axis (- fx_imh ref_y_axis))
	    )
	  )
	)
	(gimp-levels fxlayer 0 ray_edge 255 1.0 0 255)
	(plug-in-mblur 1 fximage fxlayer 2 blur_factor 0 ref_x_axis ref_y_axis)
	(if (> ray_color_opc 0)
	  (begin
	    (set! colorlayer (car (gimp-layer-new fximage fx_imw fx_imh 1 "Ray Studio (цветовой оверлей)" ray_color_opc 0)))
	    (gimp-brightness-contrast fxlayer 0 (/ (- 0 ray_color_opc) 3))
	    (gel-image-insert-layer fximage colorlayer -1)
	    (gimp-context-set-foreground ray_color)
	    (gimp-edit-fill colorlayer 0)
	    (gimp-layer-set-mode colorlayer 13)
	    (set! fxlayer (car (gimp-image-merge-down fximage colorlayer 0)))
	    (gimp-context-set-foreground fore)
	  )
	)
	(if (= rotated TRUE)
	  (gimp-image-rotate fximage 1)
	)
	(set! reslayer (car (gimp-layer-new-from-drawable fxlayer image)))
	(gel-image-insert-layer image reslayer -1)
	(gel-item-set-name reslayer "Результат")
	(if (> blur_degd 0)
	  (gel-layer-scale-full reslayer org_imw org_imh FALSE 2)
	)
	(gimp-layer-set-mode reslayer 4)
	(gimp-image-undo-group-end image)
	(gimp-image-delete fximage)
	(gimp-displays-flush)
  )
)

(script-fu-register
"script-fu-ray-studio"
"<Image>/Filters/RSS/Ray S_tudio"
"Создание лучей с контролируемым разрешением"
"Непочатов Станислав"
"Свободная лицензия"
"27 ноября 2011"
"RGB,RGBA*"
SF-IMAGE	"Image"				0
SF-DRAWABLE	"Layer"				0
SF-ADJUSTMENT	"Световая граница"		'(0 0 255 15 45 1 0)
SF-COLOR	"Цвет лучей"			'(134 164 225)
SF-ADJUSTMENT	"Степень тонировки лучей"	'(45 0 100 10 10 1 0)
SF-VALUE	"Координата X"			"0"
SF-VALUE	"Координата Y"			"0"
SF-VALUE	"Величина размытия"		"0"
SF-OPTION	"Снизить разрешение"		'(
						"1 (медленно)"
						"1/2"
						"1/4"
						"1/8"
						"1/16 (плохое качество)"
						)
)