; resynthesize_pattern_fill.scm
; by Rob Antonishen
; http://ffaat.pointclark.net

; Version 1.2 (20100705)

; Changes:
; 1.1 - changed use of global buffer to named buffer
; 1.2 - check fro old 11 or new 13 parameter version of resynthisizer.

; Description
;
; Provides a nice front end to the resynthesize filter to make a seamless fill.
;

; License:
;
; This program is free software; you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation; either version 2 of the License, or
; (at your option) any later version. 
;
; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; The GNU Public License is available at
; http://www.gnu.org/copyleft/gpl.html

(define (script_fu_resynthesize_pattern_fill img inLayer inPattern)
  (let*
    (
    (width (car (gimp-drawable-width inLayer)))
    (height (car (gimp-drawable-height inLayer)))
    (varHandler (car (gimp-message-get-handler)))
    (selEmpty (car (gimp-selection-is-empty img)))
    (newImage 0)
    (newLayer 0)
    (noiseLayer 0)
    (buffname "resynthbuff")
    )
    ;  it begins here
    (gimp-context-push)
    (gimp-image-undo-group-start img)
    
    ;logging
    ;(gimp-message-set-handler ERROR-CONSOLE)
    ;(gimp-message-set-handler CONSOLE)
    ;(gimp-message-set-handler MESSAGE-BOX)
    ;or start GIMP wwith "gimp --console-messages" to spawn a console box
    ;then use this:
    ;(gimp-message "foobar") 

    ;testing for functions defined
    ;(if (defined? 'plug-in-shift) (gimp-message "It Exists") (gimp-message "Doesnt Exist"))

    (if (defined? 'plug-in-resynthesizer) 
    (begin  ; plugin exists!
      
      (if (= (string-length inPattern) 0) (set! inPattern (car (gimp-context-get-pattern))))

      (if (= selEmpty TRUE) (gimp-selection-all img)) 
      (set! buffname (car (gimp-edit-named-copy inLayer buffname)))
      
      (set! newImage (car (gimp-edit-named-paste-as-new buffname)))
      (set! newLayer (car (gimp-image-get-active-layer newImage)))
  
      (gimp-context-set-pattern inPattern)
      (gimp-drawable-fill newLayer PATTERN-FILL)
      
      (set! noiseLayer (car (gimp-layer-new-from-drawable newLayer newImage)))
      (gimp-image-add-layer newImage noiseLayer -1)

      (plug-in-solid-noise RUN-NONINTERACTIVE newImage noiseLayer 1 0 (rand 32768) 1 (min 16.0 (/ width (car (gimp-pattern-get-info inPattern))))
                                                                                     (min 16.0 (/ height (cadr (gimp-pattern-get-info inPattern)))))

      (gimp-threshold noiseLayer 127 255)
      (gimp-by-color-select noiseLayer (list 0 0 0) 0 CHANNEL-OP-REPLACE TRUE TRUE 5 FALSE)
      
      ; check for 11 or 13 parameter version of resynthesizer
      (cond
        ((= (list-ref (gimp-procedural-db-proc-info "plug-in-resynthesizer") 6) 11)
          (plug-in-resynthesizer RUN-NONINTERACTIVE newImage newLayer 0 0 0 newLayer -1 -1 0 0.05)   
          (gimp-selection-invert newImage)
          (plug-in-resynthesizer RUN-NONINTERACTIVE newImage newLayer 0 0 0 newLayer -1 -1 0 0.05)
        )
        ((= (list-ref (gimp-procedural-db-proc-info "plug-in-resynthesizer") 6) 13)
          (plug-in-resynthesizer RUN-NONINTERACTIVE newImage newLayer 0 0 0 newLayer -1 -1 0 0.05 30 200)   
          (gimp-selection-invert newImage)
          (plug-in-resynthesizer RUN-NONINTERACTIVE newImage newLayer 0 0 0 newLayer -1 -1 0 0.05 30 200)
        )
      )

      (gimp-selection-all newImage)
      (set! buffname (car (gimp-edit-named-copy newLayer buffname)))
      
      (gimp-floating-sel-anchor (car (gimp-edit-named-paste inLayer buffname TRUE)))
      
      ; if no selection clear the selection
      (if (= selEmpty TRUE) (gimp-selection-none img))
      
      (gimp-image-delete newImage)
      
    )
    (begin ; else plugin doesn't exist
      (gimp-message-set-handler MESSAGE-BOX)
      (gimp-message "This script requires the resynthesizer plugin!")
      (gimp-message-set-handler varHandler)
    )
    )     

    ;done
    (gimp-image-undo-group-end img)
    
    (gimp-progress-end)
    (gimp-displays-flush)
    (gimp-context-pop)
  )
)

(script-fu-register "script_fu_resynthesize_pattern_fill"
                    "<Image>/Edit/Fill with resynthesized pattern..."
                    "uses the resynthesizer plugin to fill an area with a synthesized version of the pattern."
                    "Rob Antonishen"
                    "Rob Antonishen"
                    "April 2009"
                    "RGB* GRAY*"
                    SF-IMAGE      "image"      0
                    SF-DRAWABLE   "drawable"   0
                    SF-PATTERN    "Pattern"    ""
)