#!/usr/bin/env python
# -*- coding: utf-8 -*-
#

from gimpfu import *
import os, string, sys
import os.path
from os.path import basename
import collections



def log(*s):
    line = ''
    for x in s:
        line += repr(x) + '\t'
    line += '\n'
    open(r'd:\temp\gimp-log.txt', 'a').write(line)


def choose_likely_initial_dir() :
    ''' copied from akkana from github '''
    counts = collections.Counter()
    for img in gimp.image_list() :
        if img.filename :
            counts[os.path.dirname(img.filename)] += 1

    try :
        return counts.most_common(1)[0][0]
    except :
        return None



def save_as_win32(initial_dir, default, title="Save As", types='*.xcf'):
    from win32 import win32gui, win32con

    initial_file = default
    filter_string = 'All Files\0' + types + '\0'
    (filename, customfilter, flags) = \
        win32gui.GetSaveFileNameW(InitialDir=initial_dir,
                    Flags=win32con.OFN_EXPLORER, File=initial_file,
                    Title=title, Filter=filter_string,
                    #DefExt='txt',
                    FilterIndex=0)
    #raise Exception, filename
    return filename


def save_as_wx(initial_dir, default, title="Save As", ext='xcf'):
    import wx
    app=wx.App()
    filename = wx.SaveFileSelector(what=title, extension='xcf', default_name=default)
    return filename


def save_as_tkinter(title='Export As...', msg='', default='', types='*.png', user_dir=None):
    # easygui is a light wrapper around gtk;
    # i coudln't test it, so it's not included here
    import easygui
    if not user_dir:
        user_dir = ''
    ret = easygui.filesavebox(title, msg, default, filetypes='*.jpg')
    return ret





def python_fu_save_windows_dialog(active_image, drawable):
    ''' includes code by Akkana Peck:
    https://github.com/akkana/gimp-plugins/blob/master/save-export-clean.py'''

    title = 'Export As'
    msg = '(gimp)'
    default_file_name = active_image.filename
    initial_dir = choose_likely_initial_dir()
    from library import log
    log('initial_dir', initial_dir)

    if not default_file_name:
        if not initial_dir :
            initial_dir = ''

    try:
        f = save_as_wx(initial_dir, default_file_name)
    except:
        try:
            f = save_as_tkinter(default=default_file_name, types='*.png')
        except:
            f = save_as_win32(initial_dir, default_file_name, title="Export As", types='*.png')

    # save outfile as default for next time?

    log('f', f)

    if f:
        pdb.gimp_image_set_filename(active_image, f)
        pdb.gimp_file_save(active_image, drawable, f, basename(f))
        pdb.gimp_image_clean_all(active_image)
        #dupe = active_image.duplicate()
        #this_layer = pdb.gimp_image_merge_visible_layers(dupe, EXPAND_AS_NECESSARY)
        #pdb.gimp_file_save(dupe, dupe.layers[0], f, basename(f))
        pdb.gimp_image_clean_all(active_image)


# ------------------- open ------------------------------

def open_as_win32(initial_dir, default, title="Open...", types='*.xcf'):
    from win32 import win32gui, win32con

    initial_file = default
    filter_string = 'All Files\0' + types + '\0'
    filename, customfilter, flags = win32gui.GetOpenFileNameW(
        InitialDir=initial_dir,
        #DefExt='txt',
        Flags=win32con.OFN_ALLOWMULTISELECT|win32con.OFN_EXPLORER,
        File=initial_file,
        DefExt='py',
        Title=title,
        Filter=filter_string,
        FilterIndex=0
    )

    return filename


def open_as_tkinter(title='Export As...', msg='', default='', types='*.png', user_dir=None):
    import tweaked_easygui
    if not user_dir:
        user_dir = ''
    ret = tweaked_easygui.fileopenbox(title, msg, default, filetypes='*.jpg', user_dir=user_dir)
    return ret


def open_as_wx(default, ext='xcf', title='Open...'):
    import wx
    app=wx.App()
    filename = wx.FileSelector(title, '', default, 'xcf') #, wildcards, flags, parent, x, y)
    return filename


def python_fu_open_windows_dialog():
    title = 'Open...'
    msg = '(gimp)'
    default_file_name = ''
    initial_dir = ''
    try:
        f = open_as_wx(default_file_name, ext='xcf', title=title)
    except:
        try:
            f = open_as_tkinter(default=default_file_name, types='*.*', user_dir=None)
            raise Exception, '2'+f
        except:
            f = open_as_win32(initial_dir, default_file_name, title="Open", types='*.*')
            raise Exception, '3'+f
    # open outfile as default for next time?

    if f and os.path.isfile(f):
        image = pdb.gimp_file_load(f, basename(f))
        display = gimp.Display(image)
        pdb.gimp_image_clean_all(image)
    else:
        raise Exception, 'wtf file is not a file?' + str(f)



# --------------------------------- register -----------------------------------


#register( proc_name, blurb, help, author, copyright, date, label,
#             imagetypes, params, results, function,
#             menu=None, domain=None, on_query=None, on_run=None
register(
    proc_name="save-windows-dialog",
    blurb="Save Windows Dialog 20140321\nUse a windows dialog instead of the non-friendly gtk save and export dialog",
    help="Save Windows Dialog 20140321\nUse a windows dialog instead of the non-friendly gtk save and export dialog",
    author="Keshef, from gimpchat.com forums",
    copyright="GPL V2 License",
    date="2014",
    label="<Image>/File/_Save Windows Dialog...",
    imagetypes="*",
    params=[],
    results=[],
    function=python_fu_save_windows_dialog,
    #menu=None,
    #domain=("gimp20-python", gimp.locale_directory),
    #on_query=None,
    #on_run=None
    )


register(
    proc_name="open-windows-dialog2",
    blurb="Open Windows Dialog2 \nUse a windows dialog instead of the non-friendly gtk open and export dialog",
    help="Open Windows Dialog2 \nUse a windows dialog instead of the non-friendly gtk open and export dialog",
    author="Keshef, from gimpchat.com forums",
    copyright="GPL V2 License",
    date="2014",
    label="<Toolbox>/File/_Open Windows Dialog2...",
    imagetypes="",
    params=[],
    results=[],
    function=python_fu_open_windows_dialog,
    #menu=None
    #domain=("gimp20-python", gimp.locale_directory)
    )

main()
