;;;  Arch. Giuseppe Conte <http://xoomer.alice.it/lwcon/>
;;; Studio Tecnico Arch. Giuseppe Conte  
;;; via Roma, 28
;;; 72026 - San Pancrazio Salentino (BR) - Italy
;;;
;;; Plugin  : selection-to-array.scm
;;; Author  : Arch. Giuseppe Conte 
;;; Date    : 31 luglio 2003 - San Pancrazio Sal (BR) - Italy
;;; Revision: 16 marzo 2008 update to TinyScheme
;;; 					
;;; Version : 2.4
;;; Last version at: http://xoomer.alice.it/lwcon/gimp/script-fu/selection-to-array.htm
;;; Help guide at  : http://xoomer.alice.it/lwcon/gimp/script-fu/selection-to-array.htm
;;; Required : Gimp 2.4 or last
;;;
;;; Description: 
;;; Convert active selection to an array n x m.
;;; -----------------------------------------------------------------------------
;;;
;;; License:
;;; This program is free software; you can redistribute it and/or modify
;;; it under the terms of the GNU General Public License as published by
;;; the Free Software Foundation; either version 2 of the License, or
;;; (at your option) any later version.
;;; 
;;; This program is distributed in the hope that it will be useful,
;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;; GNU General Public License for more details.
;;; 
;;; You should have received a copy of the GNU General Public License
;;; along with this program; if not, write to the Free Software
;;; Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

;;; Define the function:

(define (script-fu-selection-to-array inImage inLayer righe colonne dy dx )
	(let*	(	(drawable)
					(xsel)
					(ysel)
					(xofset)
					(yofset)
					(ycount)
				)
	
	(set! drawable inLayer)

	;(gimp-selection-float inLayer dx dy)
	
  (gimp-edit-copy drawable)


;;coordinate dell'angolo superiore sinistro della selezione 

  (set! xsel (cadr (gimp-selection-bounds inImage)))
  (set! ysel (caddr (gimp-selection-bounds inImage)))

  (set! xofset xsel)
  (set! yofset ysel)

  (set! ycount 0)
  
  (while (< ycount righe)
  
  	(begin
			(set! yofset (+ ysel (* dy ycount)))
 			;(draw-riga colonne xsel dx yofset)
 			 			(draw-riga colonne xsel dx yofset drawable)
  		(set! ycount (+ ycount 1))
  	);end begin

;(gimp-message   "STO qua")

  );end while
  

       (gimp-displays-flush)
	);let	
) ;;def


(define (draw-riga ncol xsel dx yofs drawable)
	(let* (	(gcount)
					(xofset)
					(sel-float)
				)
	
	(set! gcount 0)

  (while (< gcount ncol) 
    (begin
			(set! xofset (+ xsel (* dx gcount) ))
			(set! sel-float (car (gimp-edit-paste drawable FALSE)))
  		(gimp-layer-set-offsets sel-float xofset yofs)  
  		(gimp-floating-sel-anchor sel-float)	
  		(set! gcount (+ gcount 1))
    );begin
  );while	

  );let
);def



(script-fu-register
 "script-fu-selection-to-array"
 _"<Image>/_ATG/_Array/Selection to _array"
 "Convert active selection to an array n x m."
 "Arch. Giuseppe Conte <http://xoomer.alice.it/lwcon/gimp/>"
 "Giuseppe Conte"
 "16 marzo 2008 - San Pancrazio Sal (BR) - Italy"
 "RGB* GRAY* INDEXED*"
 SF-IMAGE "The Image" 0
 SF-DRAWABLE "The Layer" 0
 SF-ADJUSTMENT "Righe" '(0 0 9999 1 10 0 1)
 SF-ADJUSTMENT "Colonne" '(0 0 9999 1 10 0 1)
 SF-ADJUSTMENT "Distanza tra le righe" '(0 -9999 9999 1 10 0 1)
 SF-ADJUSTMENT "Distanza tra le colonne" '(0 -9999 9999 1 10 0 1)
)
