;;; Studio Tecnico Arch. Giuseppe Conte  
;;; via Roma, 28
;;; 72026 - San Pancrazio Salentino (BR) - Italy
;;;
;;; Plugin  : selection-to-polar-array.scm
;;; Author  : Arch. Giuseppe Conte 
;;; Date    : 10 giugno 2003 - San Pancrazio Sal (BR) - Italy
;;; Revision: 16 marzo 2008  update to TinyScheme
;;;						18 ottobre 2009 update to GIMP 2.6
;;; 					
;;; Version : 2.6
;;; Last version at: http://xoomer.alice.it/lwcon/gimp/script-fu/selection-to-polar-array.htm
;;; Help guide at  : http://xoomer.alice.it/lwcon/gimp/script-fu/selection-to-polar-array.htm
;;; Required : Gimp 2.6 or last
;;;
;;; Description: 
;;; Draw an polar array from active selection.
;;; -----------------------------------------------------------------------------
;;;
;;; License:
;;; This program is free software; you can redistribute it and/or modify
;;; it under the terms of the GNU General Public License as published by
;;; the Free Software Foundation; either version 2 of the License, or
;;; (at your option) any later version.
;;; 
;;; This program is distributed in the hope that it will be useful,
;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;; GNU General Public License for more details.
;;; 
;;; You should have received a copy of the GNU General Public License
;;; along with this program; if not, write to the Free Software
;;; Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

;;; Define the function:

(define (script-fu-selection-to-polar-array inImage inLayer xCenter yCenter Radius Passo elementi)

	(let* (	(drawable inLayer)
					;;coordinate dell'angolo superiore sinistro della selezione 
					(xsel (cadr (gimp-selection-bounds inImage)))
					(ysel (caddr (gimp-selection-bounds inImage)))
					
					(gcount 0) 
					(xofset xsel) 
					(yofset ysel) 
					(arco (* Passo elementi))
					(angolo Passo) 
					(alfa (* angolo (/ 3.14 180))) 
					(beta alfa)
					(sel-float 0)
				)
	
  (gimp-edit-copy drawable)
	
; numero di righe      
  (while (<= gcount elementi) 
    (begin
			(set! xofset (+ xCenter ( * Radius (cos alfa)) ))
			(set! yofset (- yCenter ( * Radius (sin alfa)) ))
			(set! sel-float (car (gimp-edit-paste drawable FALSE)))
  		(gimp-layer-set-offsets sel-float xofset yofset)  
  		(gimp-floating-sel-anchor sel-float)
  		(set! alfa (+ alfa beta))	
  		(set! gcount (+ gcount 1))
    );begin
  );while		

       (gimp-displays-flush)
	);let
) ;;def


(script-fu-register
 "script-fu-selection-to-polar-array"
 _"<Image>/_ATG/_Array/_Selection to polar array"
 "Draw an polar array from active selection."
 "Arch. Giuseppe Conte <http://xoomer.alice.it/lwcon/gimp/>"
 "2009, Giuseppe Conte"
 "18 ottobre 2009 - 72026 San Pancrazio Sal (BR) - Italy"
 "RGB* GRAY* INDEXED*"
 SF-IMAGE "The Image" 0
 SF-DRAWABLE "The Layer" 0
 SF-ADJUSTMENT "Center x" '(0 0 9999 1 10 0 1)
 SF-ADJUSTMENT "Center y" '(0 0 9999 1 10 0 1)
 SF-ADJUSTMENT "Radius" '(0 -9999 9999 1 10 0 1)
 SF-ADJUSTMENT "Step" '(0 -9999 9999 1 10 0 1)
 SF-ADJUSTMENT "Element" '(0 -9999 9999 1 10 0 1)
)
