/* GIMP srs-gimpviewabledialog-0.1
 * File: srs_gimp_viewable_dialog.h v 0.1
 * Author: Randall Sawyer <srandallsawyer@gmail.com>
 * Copyright (C) 2011  Randall Sawyer
 * All Rights Reserved.
 * Date: 2011-03-03
 *
 * This is the C header file for code which emulates the built-in GIMP
 * 'GimpViewableDialog' widget - a dialog window with a raised frame at the top
 * which contains an icon, a description in a "larger" bold font, the name of
 * the active image or drawable in a "smaller" font, and a thumbnail icon of the
 * image or drawable (the "viewable").  The purpose of this reverse engineering
 * is to provide plugin developers the means to create viewable-specific dialog
 * windows which have the same "look and feel" as those used by the GIMP's
 * built-in tools.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHOR BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * Except as contained in this notice, the name of the Author of the
 * Software shall not be used in advertising or otherwise to promote the
 * sale, use or other dealings in this Software without prior written
 * authorization from the Author.
 */

#ifndef SRS_GIMP_VIEWABLE_DIALOG_H
#define SRS_GIMP_VIEWABLE_DIALOG_H

typedef enum
{
  GVD_IMAGE,
  GVD_DRAWABLE,
} GVDType;

GtkWidget *
srs_gimp_viewable_dialog_new (const gchar      *title,      // see: GimpDialog
                              const gchar      *role,       // see: GimpDialog
                              GtkWidget        *parent,     // see: GimpDialog
                              GtkDialogFlags    flags,      // see: GimpDialog

                              GVDType           view_type,  // enumeration
                              gint32            view_id,    // image_ID or
/* These arguments must be                                     drawable_ID    */
/* defined by the user     */ GtkWidget        *icon,       // GtkImage *
/* before they are passed  */ const gchar      *desc,       // Contextual title
/* into this function.     */ GtkIconSize       thumb_size, // Same is icon
/* Arguments 'icon' and    */ GtkWidget        *content_box,// For ui widgets
/* 'content_box' will be   */
/* packed and made visible */ GimpHelpFunc      help_func,  // see: GimpDialog
/* by the function.        */ const gchar      *help_id,    // see: GimpDialog
                              ...                           // see: GimpDialog
                             );

#endif  /* SRS_GIMP_VIEWABLE_DIALOG_H */
