#define __TEXTUREWERKE_BLUR_CPP__

//
// Polynome fitting
//

#include <math.h>

#include "texturewerke.h"

// Blur image in x dimension by specified kernel, write destination and new weights
static void blur_x (float *dpx, int width, int height, float *dwx, const float *spx, int ksize, double kernel[]);
static void blur_x (float *dpx, int width, int height, float *dwx, const float *spx, const float *swx, int ksize, double kernel[]);
static void blur_y (float *dpx, int width, int height, float *dwx, const float *spx, const float *swx, int ksize, double kernel[]);

static void
build_normalized_kernel (int size, double sigma, double kernel[])
{
	double sum = 0;
	for (int k = -size; k <= size; k++) {
		double val = k / sigma;
		val = exp (-val * val);
		kernel[size + k] = val;
		sum += val;
	}
	for (int k = -size; k <= size; k++) kernel[size + k] /= sum;
}

void
blur (float *d, int width, int height, float *dm, const float *s, const float *sm, float *b[], float blurx, float blury, float p0, float p1)
{
	// Blur unmasked
	// Build normalized kernel
	double w[769];
	int kwidth = (int) (blurx * 3);
	build_normalized_kernel (kwidth, blurx, w);
	if (sm) {
		blur_x (b[0], width, height, b[1], s, sm, kwidth, w);
	} else {
		blur_x (b[0], width, height, b[1], s, kwidth, w);
	}
	gimp_progress_update ((p0 + p1) / 2);
	kwidth = (int) (blury * 3);
	build_normalized_kernel (kwidth, blury, w);
	blur_y (d, width, height, dm, b[0], b[1], kwidth, w);
	gimp_progress_update (p1);
}

// Blur image in x dimension by specified kernel, write destination and new weights

static void
blur_x (float *dpx, int width, int height, float *dwx, const float *spx, int ksize, double kernel[])
{
	double maxpixels = 2 * ksize + 1;
	for (int yc = 0; yc < height; yc++) {
		for (int xc = 0; xc < width; xc++) {
			double sumweights = 0;
			double sumvalues = 0;
			double numpixels = 0;
			int x0 = xc - ksize;
			if (x0 < 0) x0 = 0;
			int x1 = xc + ksize;
			if (x1 >= width) x1 = width - 1;
			for (int x = x0; x <= x1; x++) {
				int k = ksize + x - xc;
				double weight = kernel[k];
				sumweights += weight;
				sumvalues += weight * spx[yc * width + x]; 
				numpixels += 1;
			}
			double coverage = maxpixels / numpixels;
			sumweights *= coverage;
			sumvalues *= coverage;
			// Normalize
			if (sumweights) sumvalues /= sumweights;
			dpx[yc * width + xc] = (float) sumvalues;
			if (dwx) dwx[yc * width + xc] = (float) sumweights;
		}
	}
}

static void
blur_x (float *dpx, int width, int height, float *dwx, const float *spx, const float *swx, int ksize, double kernel[])
{
	double maxpixels = 2 * ksize + 1;
	for (int yc = 0; yc < height; yc++) {
		for (int xc = 0; xc < width; xc++) {
			double sumweights = 0;
			double sumvalues = 0;
			double numpixels = 0;
			int x0 = xc - ksize;
			if (x0 < 0) x0 = 0;
			int x1 = xc + ksize;
			if (x1 >= width) x1 = width - 1;
			for (int x = x0; x <= x1; x++) {
				int k = ksize + x - xc;
				double weight = kernel[k] * swx[yc * width + x];
				sumweights += weight;
				sumvalues += weight * spx[yc * width + x]; 
				numpixels += 1;
			}
			double coverage = maxpixels / numpixels;
			sumweights *= coverage;
			sumvalues *= coverage;
			// Normalize
			if (sumweights) sumvalues /= sumweights;
			dpx[yc * width + xc] = (float) sumvalues;
			if (dwx) dwx[yc * width + xc] = (float) sumweights;
		}
	}
}

// Blur image in y dimension by specified kernel, write destination and new weights

static void
blur_y (float *dpx, int width, int height, float *dwx, const float *spx, const float *swx, int ksize, double kernel[])
{
	double maxpixels = 2 * ksize + 1;
	for (int xc = 0; xc < width; xc++) {
		for (int yc = 0; yc < height; yc++) {
			double sumweights = 0;
			double sumvalues = 0;
			double numpixels = 0;
			// Ignore pixels with zero weigth
			if (swx[yc * width + xc]) {
				int y0 = yc - ksize;
				if (y0 < 0) y0 = 0;
				int y1 = yc + ksize;
				if (y1 >= height) y1 = height - 1;
				for (int y = y0; y <= y1; y++) {
					int k = ksize + y - yc;
					double weight = kernel[k] * swx[y * width + xc];
					sumweights += weight;
					sumvalues += weight * spx[y * width + xc]; 
					numpixels += 1;
				}
			}
			double coverage = maxpixels / numpixels;
			sumweights *= coverage;
			sumvalues *= coverage;
			// Normalize
			if (sumweights) sumvalues /= sumweights;
			dpx[yc * width + xc] = (float) sumvalues;
			if (dwx) dwx[yc * width + xc] = (float) sumweights;
		}
	}
}

