#define __TEXTUREWERKE_BUFFER_CPP__

//
// Polynome fitting
//

#include <math.h>

#include "texturewerke.h"

void
get_buffer (float *d, GimpDrawable *drawable, int channel)
{
	int width = drawable->width;
	int height = drawable->height;
	int bpp = drawable->bpp;
	unsigned char *px = g_new (unsigned char, width * height * bpp);
	GimpPixelRgn region;
	gimp_pixel_rgn_init (&region, drawable, 0, 0, width, height, 0, 0);
	gimp_pixel_rgn_get_rect (&region, px, 0, 0, width, height);
	get_buffer (d, width, height, px, width * bpp, bpp, channel);
	g_free (px);
}

void
get_buffer (float *d, int width, int height, const unsigned char *px, int rowstride, int bpp, int channel)
{
	for (int r = 0; r < height; r++) {
		for (int c = 0; c < width; c++) {
			d[r * width + c] = px[r * rowstride + c * bpp + channel] / 255.0f;
		}
	}
}

void
apply_buffer (unsigned char *d, int width, int height, int rowstride, int bpp, int channel, const float *b)
{
	for (int r = 0; r < height; r++) {
		for (int c = 0; c < width; c++) {
			float val = b[r * width + c];
			if (val < 0) val = 0;
			if (val > 1) val = 1;
			d[r * rowstride + c * bpp + channel] = (unsigned char) (val * 255.9999);
		}
	}
}
