#define __TEXTUREWERKE_COLOR_UI_CPP__

//
// Texture workshop for GIMP
//
// Copyright (C) Lauris Kaplinski 2007-2011
//
// Licensed under GNU GPL
//

static const int debug = 1;

#include <gtk/gtk.h>
#include <libgimp/gimp.h>
#include <libgimp/gimpui.h>

#include "texturewerke.h"

#define PADDING 4

struct ColorWidgetData {
	unsigned int inupdate;
	HParams *params;
	GtkWidget *check_blur;
	GtkWidget *kernel;
};

static void
widget_destroy (GtkObject *object, ColorWidgetData *wdata)
{
	g_free (wdata);
}

static gint
layer_constraint (gint32 image_id, gint32 drawable_id, HParams *params)
{
	return true;
}

static void
source_layer_changed (GtkComboBox *combo, HParams *params)
{
	int value;
	if (gimp_int_combo_box_get_active (GIMP_INT_COMBO_BOX(combo), &value)) {
		params->other_layer_id = value;
		params->other_mask_id = gimp_layer_get_mask (value);
		if (debug) g_log ("TextureWerke", G_LOG_LEVEL_DEBUG, "Layer %d Mask %d\n", params->other_layer_id, params->other_mask_id);
	}
}

static void
blur_toggled (GtkToggleButton *button, ColorWidgetData *wdata)
{
	int active = gtk_toggle_button_get_active (button);
	wdata->params->color_use_blur = active;
	gtk_widget_set_sensitive (wdata->kernel, active);
}

GtkWidget *
build_color_widget (HParams *params)
{
	ColorWidgetData *wdata = g_new (ColorWidgetData, 1);
	wdata->inupdate = 1;
	wdata->params = params;

	GtkWidget *vbox = gtk_vbox_new (false, PADDING);
	gtk_container_set_border_width (GTK_CONTAINER(vbox), PADDING);
	g_object_set_data (G_OBJECT(vbox), "wdata", wdata);
	g_signal_connect (G_OBJECT(vbox), "destroy", G_CALLBACK(widget_destroy), wdata);

	// Template selector
	GtkWidget *frame = gtk_frame_new ("Template");
	gtk_widget_show (frame);
	gtk_box_pack_start (GTK_BOX(vbox), frame, false, true, 0);
	GtkWidget *vbox_template = gtk_vbox_new (false, PADDING);
	gtk_widget_show (vbox_template);
	gtk_container_set_border_width (GTK_CONTAINER(vbox_template), PADDING);
	gtk_container_add (GTK_CONTAINER(frame), vbox_template);
	GtkWidget *combo = gimp_layer_combo_box_new ((GimpDrawableConstraintFunc) layer_constraint, params);
	gtk_widget_show (combo);
	gtk_box_pack_start (GTK_BOX(vbox_template), combo, false, true, 0);
	gimp_int_combo_box_connect (GIMP_INT_COMBO_BOX(combo), params->other_layer_id, G_CALLBACK(source_layer_changed), params);

	// Frame
	frame = gtk_frame_new ("Blur");
	gtk_widget_show (frame);
	gtk_box_pack_start (GTK_BOX(vbox), frame, false, true, 0);
	// VBox
	GtkWidget *vbox_blur = gtk_vbox_new (false, PADDING);
	gtk_widget_show (vbox_blur);
	gtk_container_set_border_width (GTK_CONTAINER(vbox_blur), PADDING);
	gtk_container_add (GTK_CONTAINER(frame), vbox_blur);
	// Checkbox
	wdata->check_blur = gtk_check_button_new_with_label ("Blur images before adjustment");
	gtk_widget_show (wdata->check_blur);
	gtk_box_pack_start (GTK_BOX(vbox_blur), wdata->check_blur, false, true, 0);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(wdata->check_blur), params->color_use_blur);
	g_signal_connect (G_OBJECT(wdata->check_blur), "toggled", G_CALLBACK(blur_toggled), wdata);
	// Table of sigmas
	wdata->kernel = kernel_widget_new (&wdata->params->color_blur_x, &wdata->params->color_blur_y, NULL, 0.1f, 16.0f, 0.1f);
	gtk_widget_show (wdata->kernel);
	gtk_widget_set_sensitive (wdata->kernel, params->color_use_blur);
	gtk_box_pack_start (GTK_BOX(vbox_blur), wdata->kernel, false, true, 0);

	wdata->inupdate = 0;

	return vbox;
}

void
color_page_selected (GtkWidget *widget, HParams *params)
{
	ColorWidgetData *wdata = (ColorWidgetData *) g_object_get_data (G_OBJECT(widget), "dlgdata");
	params->method = METHOD_COLOR;
}

