#define __TEXTUREWERKE_DIALOG_CPP__

//
// Lowpass filter for Gimp
//
// Copyright (C) Lauris Kaplinski 2007-2011
//
// Licensed under GNU GPL
//

#include <string.h>

#include <libgimp/gimp.h>
#include <libgimp/gimpui.h>

#include "texturewerke.h"

enum Pages { PAGE_COLOR, PAGE_LOWPASS, PAGE_ABOUT, NUM_PAGES };

static const char *about = ""
	"Texturewerke\n\n"
	"GIMP plugin for creating textures\n"
	"http://khayyam.kaplinski.com/\n\n"
	"Copyright Lauris Kaplinski 2011\n"
	"Levenberg-Marquardt optimizer\n"
	"Copyright Manolis Lourakis\n\n"
	"Released under GNU GPL version 3"
	"";

struct DialogData {
	unsigned int inupdate;
	HParams *hparams;
	GtkWidget *color;
	GtkWidget *lowpass;
};

#define PADDING 4

static void
notebook_switch_page (GtkNotebook *notebook, GtkWidget *page, unsigned int page_num, DialogData *dlgdata)
{
	if (page_num == PAGE_COLOR) {
		color_page_selected (dlgdata->color, dlgdata->hparams);
	} else if (page_num == PAGE_LOWPASS) {
		lowpass_page_selected (dlgdata->lowpass, dlgdata->hparams);
	}
}

unsigned int
dialog_main_run (HParams *params)
{
	gimp_ui_init ("TextureWerke", 0);

	DialogData dlgdata;

	dlgdata.inupdate = 1;
	dlgdata.hparams = params;

	char *title = g_strdup_printf ("Texturewerke %s", VERSION);
	GtkWidget *dialog = gimp_dialog_new (title, "texturewerke", NULL,
                            (GtkDialogFlags) 0, gimp_standard_help_func, 0,
                            GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
                            GTK_STOCK_OK, GTK_RESPONSE_OK,
                            0);
	g_free (title);
	GtkWidget *notebook = gtk_notebook_new ();
	gtk_container_set_border_width (GTK_CONTAINER(notebook), PADDING);
	gtk_box_pack_start (GTK_BOX(GTK_DIALOG(dialog)->vbox), notebook, true, true, 0);

	dlgdata.color = build_color_widget (params);
	GtkWidget *label = gtk_label_new ("Adjust color");
	gtk_notebook_append_page (GTK_NOTEBOOK(notebook), dlgdata.color, label);

	dlgdata.lowpass = build_lowpass_widget (params);
	label = gtk_label_new ("Highpass");
	gtk_notebook_append_page (GTK_NOTEBOOK(notebook), dlgdata.lowpass, label);

#if 0
        // Crashed on Ubuntu
	GtkWidget *scrolledwindow = gtk_scrolled_window_new (NULL, NULL);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW(scrolledwindow), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_container_set_border_width (GTK_CONTAINER(scrolledwindow), PADDING);
	GtkWidget *textview = gtk_text_view_new ();
	gtk_text_view_set_editable (GTK_TEXT_VIEW(textview), false);
	GtkTextBuffer *textbuffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW(textview));
	gtk_text_buffer_set_text (textbuffer, about, strlen(about));
	gtk_container_add (GTK_CONTAINER(scrolledwindow), textview);
	label = gtk_label_new ("About");
	gtk_notebook_append_page (GTK_NOTEBOOK(notebook), scrolledwindow, label);
#endif

	gtk_widget_show_all (notebook);
	if (params->method == METHOD_COLOR) {
		gtk_notebook_set_current_page (GTK_NOTEBOOK(notebook), PAGE_COLOR);
	} else {
		gtk_notebook_set_current_page (GTK_NOTEBOOK(notebook), PAGE_LOWPASS);
	}
	g_signal_connect (G_OBJECT(notebook), "switch-page", G_CALLBACK(notebook_switch_page), &dlgdata);

	dlgdata.inupdate = 0;

	int response = gimp_dialog_run (GIMP_DIALOG(dialog));

	return response == GTK_RESPONSE_OK;
}

