#define __TEXTUREWERKE_KERNEL_WIDGET_CPP__

//
// Texture workshop for GIMP
//
// Copyright (C) Lauris Kaplinski 2007-2011
//
// Licensed under GNU GPL
//

static const int debug = 1;

#include <gtk/gtk.h>
#include <libgimp/gimp.h>
#include <libgimp/gimpui.h>

#include "texturewerke.h"

#define PADDING 4

struct KernelWidgetData {
	unsigned int inupdate;
	float *sigma_x;
	float *sigma_y;
	float *power;
	GtkWidget *sigma_x_widget;
	GtkWidget *sigma_y_widget;
	GtkWidget *chain_sigmas_widget;
	GtkWidget *power_widget;
};

static void
widget_destroy (GtkObject *object, KernelWidgetData *wdata)
{
	g_free (wdata);
}

static void
sigma_x_value_changed (GtkSpinButton *spin, KernelWidgetData *wdata)
{
	if (wdata->inupdate) return;
	wdata->inupdate += 1;
	float value = (float) gtk_spin_button_get_value (spin);
	*wdata->sigma_x = value;
	if (gimp_chain_button_get_active (GIMP_CHAIN_BUTTON(wdata->chain_sigmas_widget))) {
		*wdata->sigma_y = value;
		gtk_spin_button_set_value (GTK_SPIN_BUTTON(wdata->sigma_y_widget), value);
	}
	wdata->inupdate -= 1;
}

static void
sigma_y_value_changed (GtkSpinButton *spin, KernelWidgetData *wdata)
{
	if (wdata->inupdate) return;
	wdata->inupdate += 1;
	float value = (float) gtk_spin_button_get_value (spin);
	*wdata->sigma_y = value;
	if (gimp_chain_button_get_active (GIMP_CHAIN_BUTTON(wdata->chain_sigmas_widget))) {
		*wdata->sigma_x = value;
		gtk_spin_button_set_value (GTK_SPIN_BUTTON(wdata->sigma_x_widget), value);
	}
	wdata->inupdate -= 1;
}

static void
power_value_changed (GtkSpinButton *spin, KernelWidgetData *wdata)
{
	if (wdata->inupdate) return;
	wdata->inupdate += 1;
	float value = (float) gtk_spin_button_get_value (spin);
	*wdata->power = value;
	wdata->inupdate -= 1;
}

GtkWidget *
kernel_widget_new (float *sigma_x, float *sigma_y, float *power, float minsigma, float maxsigma, float sigmastep)
{
	KernelWidgetData *wdata = g_new (KernelWidgetData, 1);
	wdata->inupdate = 1;
	wdata->sigma_x = sigma_x;
	wdata->sigma_y = sigma_y;
	wdata->power = power;

	GtkWidget *vbox = gtk_vbox_new (false, PADDING);
	gtk_container_set_border_width (GTK_CONTAINER(vbox), PADDING);
	g_object_set_data (G_OBJECT(vbox), "wdata", wdata);
	g_signal_connect (G_OBJECT(vbox), "destroy", G_CALLBACK(widget_destroy), wdata);

	// Table of sigmas
	GtkWidget *table = gtk_table_new (4, 6, 0);
	gtk_box_pack_start (GTK_BOX(vbox), table, false, true, 0);
	gtk_container_set_border_width (GTK_CONTAINER(table), PADDING);
	gtk_table_set_row_spacings (GTK_TABLE(table), PADDING);
	gtk_table_set_col_spacings (GTK_TABLE(table), PADDING);
	// Sigmas
	GtkWidget *label = gtk_label_new ("X Sigma:");
	gtk_misc_set_alignment (GTK_MISC(label), 1, 0.5);
	gtk_table_attach (GTK_TABLE (table), label, 0, 1, 0, 1, (GtkAttachOptions) (GTK_FILL), (GtkAttachOptions) (GTK_FILL), 0, 0);
	wdata->sigma_x_widget = gtk_spin_button_new_with_range (minsigma, maxsigma, sigmastep);
	gtk_spin_button_set_value (GTK_SPIN_BUTTON(wdata->sigma_x_widget), *sigma_x);
	gtk_table_attach (GTK_TABLE (table), wdata->sigma_x_widget, 1, 2, 0, 1, (GtkAttachOptions) (GTK_FILL), (GtkAttachOptions) (GTK_FILL), 0, 0);
	g_signal_connect (G_OBJECT(wdata->sigma_x_widget), "value-changed", G_CALLBACK(sigma_x_value_changed), wdata);

	label = gtk_label_new ("Y Sigma:");
	gtk_misc_set_alignment (GTK_MISC(label), 1, 0.5);
	gtk_table_attach (GTK_TABLE (table), label, 0, 1, 1, 2, (GtkAttachOptions) (GTK_FILL), (GtkAttachOptions) (GTK_FILL), 0, 0);
	wdata->sigma_y_widget = gtk_spin_button_new_with_range (minsigma, maxsigma, sigmastep);
	gtk_spin_button_set_value (GTK_SPIN_BUTTON(wdata->sigma_y_widget), *sigma_y);
	gtk_table_attach (GTK_TABLE (table), wdata->sigma_y_widget, 1, 2, 1, 2, (GtkAttachOptions) (GTK_FILL), (GtkAttachOptions) (GTK_FILL), 0, 0);
	g_signal_connect (G_OBJECT(wdata->sigma_y_widget), "value-changed", G_CALLBACK(sigma_y_value_changed), wdata);

	wdata->chain_sigmas_widget = gimp_chain_button_new (GIMP_CHAIN_RIGHT);
	gimp_chain_button_set_active (GIMP_CHAIN_BUTTON(wdata->chain_sigmas_widget), true);
	gtk_table_attach (GTK_TABLE (table), wdata->chain_sigmas_widget, 2, 3, 0, 2, (GtkAttachOptions) (GTK_FILL), (GtkAttachOptions) (GTK_FILL), 0, 0);

	GtkWidget *label_power = gtk_label_new ("Power:");
	gtk_misc_set_alignment (GTK_MISC(label_power), 1, 0.5);
	gtk_table_attach (GTK_TABLE (table), label_power, 0, 1, 3, 4, (GtkAttachOptions) (GTK_FILL), (GtkAttachOptions) (GTK_FILL), 0, 0);
	wdata->power_widget = gtk_spin_button_new_with_range (0.01, 100, 0.01);
	if (power) {
		gtk_spin_button_set_value (GTK_SPIN_BUTTON(wdata->power_widget), *power);
	} else {
		gtk_spin_button_set_value (GTK_SPIN_BUTTON(wdata->power_widget), 2);
	}
	gtk_table_attach (GTK_TABLE (table), wdata->power_widget, 1, 2, 3, 4, (GtkAttachOptions) (GTK_FILL), (GtkAttachOptions) (GTK_FILL), 0, 0);
	g_signal_connect (G_OBJECT(wdata->power_widget), "value-changed", G_CALLBACK(power_value_changed), wdata);

	gtk_widget_show_all (vbox);

	if (!power) gtk_widget_hide (label_power);
	if (!power) gtk_widget_hide (wdata->power_widget);

	wdata->inupdate = 0;

	return vbox;
}

