#define __TEXTUREWERKE_LOWPASS_UI_CPP__

//
// Texture workshop for GIMP
//
// Copyright (C) Lauris Kaplinski 2007-2011
//
// Licensed under GNU GPL
//

static const int debug = 1;

#include <gtk/gtk.h>
#include <libgimp/gimp.h>
#include <libgimp/gimpui.h>

#include "texturewerke.h"

#define PADDING 4

struct LowpassWidgetData {
	unsigned int inupdate;
	HParams *params;
	GtkWidget *radio_blur;
	GtkWidget *radio_polynome;
	GtkWidget *kernel;
	GtkWidget *samples;
	GtkWidget *degree_x;
	GtkWidget *degree_y;
};

static void
dialog_destroy (GtkObject *object, LowpassWidgetData *wdata)
{
	g_free (wdata);
}

static void
blur_toggled (GtkToggleButton *button, LowpassWidgetData *wdata)
{
	if (wdata->inupdate) return;
	wdata->inupdate += 1;
	if (gtk_toggle_button_get_active (button)) {
		wdata->params->method = METHOD_LOWPASS_BLUR;
		gtk_widget_set_sensitive (wdata->samples, false);
		gtk_widget_set_sensitive (wdata->degree_x, false);
		gtk_widget_set_sensitive (wdata->degree_y, false);
	}
	wdata->inupdate -= 1;
}

static void
polynome_toggled (GtkToggleButton *button, LowpassWidgetData *wdata)
{
	if (wdata->inupdate) return;
	wdata->inupdate += 1;
	if (gtk_toggle_button_get_active (button)) {
		wdata->params->method = METHOD_LOWPASS_POLYNOME;
		gtk_widget_set_sensitive (wdata->samples, true);
		gtk_widget_set_sensitive (wdata->degree_x, true);
		gtk_widget_set_sensitive (wdata->degree_y, true);
	}
	wdata->inupdate -= 1;
}

static void
samples_value_changed (GtkSpinButton *spin, LowpassWidgetData *wdata)
{
	if (wdata->inupdate) return;
	wdata->inupdate += 1;
	double value = gtk_spin_button_get_value (spin);
	wdata->params->nsamples = (unsigned int) value;
	wdata->inupdate -= 1;
}

static void
degree_x_value_changed (GtkSpinButton *spin, LowpassWidgetData *wdata)
{
	if (wdata->inupdate) return;
	wdata->inupdate += 1;
	double value = gtk_spin_button_get_value (spin);
	wdata->params->polynome_degree_x = (unsigned int) value;
	wdata->inupdate -= 1;
}

static void
degree_y_value_changed (GtkSpinButton *spin, LowpassWidgetData *wdata)
{
	if (wdata->inupdate) return;
	wdata->inupdate += 1;
	double value = gtk_spin_button_get_value (spin);
	wdata->params->polynome_degree_y = (unsigned int) value;
	wdata->inupdate -= 1;
}

GtkWidget *
build_lowpass_widget (HParams *params)
{
	LowpassWidgetData *wdata = g_new (LowpassWidgetData, 1);
	wdata->inupdate = 1;
	wdata->params = params;

	GtkWidget *vbox = gtk_vbox_new (false, PADDING);
	gtk_container_set_border_width (GTK_CONTAINER(vbox), PADDING);
	g_object_set_data (G_OBJECT(vbox), "wdata", wdata);
	g_signal_connect (G_OBJECT(vbox), "destroy", G_CALLBACK(dialog_destroy), wdata);

	// Submethod
	GtkWidget *hbox = gtk_hbox_new (0, 2);
	gtk_widget_show (hbox);
	gtk_box_pack_start (GTK_BOX(vbox), hbox, 0, 1, 4);
	wdata->radio_blur = gtk_radio_button_new_with_label_from_widget (NULL, "Gauss");
	gtk_widget_show (wdata->radio_blur);
	gtk_box_pack_start (GTK_BOX(hbox), wdata->radio_blur, 0, 1, 0);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(wdata->radio_blur), params->method == METHOD_LOWPASS_BLUR);
	g_signal_connect (G_OBJECT(wdata->radio_blur), "toggled", G_CALLBACK(blur_toggled), wdata);
	wdata->radio_polynome = gtk_radio_button_new_with_label_from_widget (GTK_RADIO_BUTTON(wdata->radio_blur), "Polynome");
	gtk_widget_show (wdata->radio_polynome);
	gtk_box_pack_start (GTK_BOX(hbox), wdata->radio_polynome, 0, 1, 0);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(wdata->radio_polynome), params->method == METHOD_LOWPASS_POLYNOME);
	g_signal_connect (G_OBJECT(wdata->radio_polynome), "toggled", G_CALLBACK(polynome_toggled), wdata);

	// Polynome
	// Frame
	GtkWidget *frame = gtk_frame_new ("Blur kernel");
	gtk_widget_show (frame);
	gtk_box_pack_start (GTK_BOX(vbox), frame, false, true, 0);
	// Table of sigmas
	wdata->kernel = kernel_widget_new (&wdata->params->polynome_blur_x, &wdata->params->polynome_blur_y, NULL, 1.0f, 128.0f, 1.0f);
	gtk_widget_show (wdata->kernel);
	gtk_container_add (GTK_CONTAINER(frame), wdata->kernel);

	// Frame
	frame = gtk_frame_new ("Polynome settings");
	gtk_box_pack_start (GTK_BOX(vbox), frame, false, true, 0);
	GtkWidget *table = gtk_table_new (3, 2, false);
	gtk_container_set_border_width (GTK_CONTAINER(table), PADDING);
	gtk_table_set_row_spacings (GTK_TABLE(table), PADDING);
	gtk_table_set_col_spacings (GTK_TABLE(table), PADDING);
	gtk_container_add (GTK_CONTAINER(frame), table);
	// Degree
	GtkWidget *label = gtk_label_new ("X degree:");
	gtk_misc_set_alignment (GTK_MISC(label), 1.0f, 0.5f);
	gtk_table_attach (GTK_TABLE(table), label, 0, 1, 0, 1, (GtkAttachOptions) GTK_FILL, (GtkAttachOptions) GTK_FILL, 0, 0);
	wdata->degree_x = gtk_spin_button_new_with_range (0, 4, 1);
	gtk_table_attach (GTK_TABLE(table), wdata->degree_x, 1, 2, 0, 1, (GtkAttachOptions) GTK_FILL, (GtkAttachOptions) GTK_FILL, 0, 0);
	gtk_spin_button_set_value (GTK_SPIN_BUTTON(wdata->degree_x), params->polynome_degree_x);
	gtk_widget_set_sensitive (wdata->degree_x, params->method == METHOD_LOWPASS_POLYNOME);
	g_signal_connect (G_OBJECT(wdata->degree_x), "value-changed", G_CALLBACK(degree_x_value_changed), wdata);
	label = gtk_label_new ("Y degree:");
	gtk_misc_set_alignment (GTK_MISC(label), 1.0f, 0.5f);
	gtk_table_attach (GTK_TABLE(table), label, 0, 1, 1, 2, (GtkAttachOptions) GTK_FILL, (GtkAttachOptions) GTK_FILL, 0, 0);

	wdata->degree_y = gtk_spin_button_new_with_range (0, 4, 1);
	gtk_table_attach (GTK_TABLE(table), wdata->degree_y, 1, 2, 1, 2, (GtkAttachOptions) GTK_FILL, (GtkAttachOptions) GTK_FILL, 0, 0);
	gtk_spin_button_set_value (GTK_SPIN_BUTTON(wdata->degree_y), params->polynome_degree_y);
	gtk_widget_set_sensitive (wdata->degree_y, params->method == METHOD_LOWPASS_POLYNOME);
	g_signal_connect (G_OBJECT(wdata->degree_y), "value-changed", G_CALLBACK(degree_y_value_changed), wdata);

	label = gtk_label_new ("Samples:");
	gtk_misc_set_alignment (GTK_MISC(label), 1.0f, 0.5f);
	gtk_table_attach (GTK_TABLE(table), label, 0, 1, 2, 3, (GtkAttachOptions) GTK_FILL, (GtkAttachOptions) GTK_FILL, 0, 0);
	wdata->samples = gtk_spin_button_new_with_range (100, 100000, 100);
	gtk_table_attach (GTK_TABLE(table), wdata->samples, 1, 2, 2, 3, (GtkAttachOptions) GTK_FILL, (GtkAttachOptions) GTK_FILL, 0, 0);
	gtk_spin_button_set_value (GTK_SPIN_BUTTON(wdata->samples), params->nsamples);
	gtk_widget_set_sensitive (wdata->samples, params->method == METHOD_LOWPASS_POLYNOME);
	g_signal_connect (G_OBJECT(wdata->samples), "value-changed", G_CALLBACK(samples_value_changed), wdata);

	gtk_widget_show_all (frame);

	wdata->inupdate = 0;

	return vbox;
}

void
lowpass_page_selected (GtkWidget *widget, HParams *params)
{
	LowpassWidgetData *wdata = (LowpassWidgetData *) g_object_get_data (G_OBJECT(widget), "wdata");
	if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(wdata->radio_blur))) {
		params->method = METHOD_LOWPASS_BLUR;
	} else if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(wdata->radio_polynome))) {
		params->method = METHOD_LOWPASS_POLYNOME;
	}
}

