//
// Polynome fitting
//

#include <stdlib.h>

#include "levmar-2.1.3/lm.h"

#include "texturewerke.h"

struct HotSpot {
	double x, y;
	double value;
	double weight;
};

#if 0
// Blur image in x dimension by specified kernel, write destination and new weights
static void blur_x (float *dpx, int width, int height, float *dwx, const float *spx, int ksize, double kernel[]);
static void blur_y (float *dpx, int width, int height, float *dwx, const float *spx, const float *swx, int ksize, double kernel[]);
#endif

// Get fit hotspot from image and weight
static void get_hotspot (HotSpot *spot, int x, int y, const float *spx, int width, int height, const float *swx);

static inline double
poly0 (double x, double y, const double p[], const double f[])
{
	return p[0] * f[0];
}

static inline double
poly1 (double x, double y, const double p[], const double f[])
{
	return p[0] * f[0] * x + p[1] * f[1] * y + poly0 (x, y, &p[2], &f[2]);
}

static inline double
poly2 (double x, double y, const double p[], const double f[])
{
	return p[0] * f[0] * x * x + p[1] * f[1] * x * y + p[2] * f[2] * y * y + poly1 (x, y, &p[3], &f[3]);
}

static double
poly3 (double x, double y, const double p[], const double f[])
{
	return p[0] * f[0] * x * x * x + p[1] * f[1] * x * x * y + p[2] * f[2] * x * y * y + p[3] * f[3] * y * y * y + poly2 (x, y, &p[4], &f[4]);
}

static double
poly4 (double x, double y, const double p[], const double f[])
{
	return p[0] * f[0] * x * x * x *x + p[1] * f[1] * x * x * x * y + p[2] * f[2] * x * x * y * y + p[3] * f[3] * x * y * y * y + p[4] * f[4] * y * y * y * y + poly3 (x, y, &p[5], &f[5]);
}

struct LMData {
	const HotSpot *spots;
	double factors[15];
};

// p - parameters
// hx - values
// m - number of parameters
// n - number of samples in set

static void
lm_func (double *p, double *hx, int m, int n, void *data)
{
	const LMData *lmdata = (const LMData *) data;
	for (int i = 0; i < n; i++) {
		double x = lmdata->spots[i].x;
		double y = lmdata->spots[i].y;
		hx[i] = poly4 (x, y, p, lmdata->factors) * lmdata->spots[i].weight;
	}
}

static int
rand_int (int min, int max)
{
	return min + (int) ((rand () / (RAND_MAX + 1.0)) * (max - min));
}

static void
build_normalized_kernel (int size, double sigma, double power, double kernel[])
{
	double sum = 0;
	for (int k = -size; k <= size; k++) {
			double val = exp (-pow (fabs (k / sigma), power));
			kernel[size + k] = val;
			sum += val;
	}
	for (int k = -size; k <= size; k++) kernel[size + k] /= sum;
}

void
process_channel_lm (float *b, int width, int height, const float *mask_buffer, const HParams *params, float *tmp[], float p0, float p1)
{
	// Blur unmasked
	// Build normalized kernel
	blur (tmp[2], width, height, tmp[3], b, mask_buffer, &tmp[0], (float) params->polynome_blur_x, (float) params->polynome_blur_y, p0, (p0 + p1) / 2);
	// b2 - blurred image
	// b3 - weights

	// Channel statistics
	double sumvalues = 0;
	double sumweights = 0;
	int npixels = 0;
	for (int y = 0; y < height; y++) {
		for (int x = 0; x < width; x++) {
			if (tmp[3][y * width + x] >= 0.0625f) {
				sumvalues += tmp[2][y * width + x];
				sumweights += tmp[3][y * width + x];
				npixels += 1;
			}
		}
	}
	if (npixels < (width * height / 10)) return;
	double avg = sumvalues / npixels;

	if (params->method == METHOD_LOWPASS_BLUR) {
		// Adjust original image
		for (int r = 0; r < height; r++) {
			for (int c = 0; c < width; c++) {
				double y = (double) r / (height - 1);
				double x = (double) c / (width - 1);
				double val = b[r * width + c] - tmp[2][r * width + c] + avg;
				if (val < 0) val = 0;
				if (val > 1) val = 1;
				b[r * width + c] = (float) val;
			}
		}
	} else {
		// Build hotspots
		unsigned int nsamples = 0;
		HotSpot *spots = g_new (HotSpot, params->nsamples);
		while (nsamples < params->nsamples) {
			int x = rand_int (0, width - 1);
			int y = rand_int (0, height - 1);
			if (tmp[3][y * width + x] >= 0.0625f) {
				get_hotspot (&spots[nsamples], x, y, tmp[2], width, height, tmp[3]);
				nsamples += 1;
			}
		}

		// Calculate approximation
		double opts[LM_OPTS_SZ] = { LM_INIT_MU, 1E-15, 1E-15, 1E-20, LM_DIFF_DELTA };
		double info[LM_INFO_SZ];
		// p - parameters
		// x - values
		// m - number of parameters
		// n - number of samples in set
		int m = 15;
		double p[100];
		for (int i = 0; i < 100; i++) p[i] = 0;
		p[14] = avg;
		int n = nsamples;
		double *x = g_new (double, nsamples);
		for (unsigned int i = 0; i < nsamples; i++) x[i] = spots[i].value;
		LMData lmdata;
		lmdata.spots = spots;
		static const unsigned int degrees_x[] = {4, 3, 2, 1, 0, 3, 2, 1, 0, 2, 1, 0, 1, 0, 0 };
		static const unsigned int degrees_y[] = {0, 1, 2, 3, 4, 0, 1, 2, 3, 0, 1, 2, 0, 1, 0 };
		for (int i = 0; i < 15; i++) {
			lmdata.factors[i] = ((degrees_x[i] <= params->polynome_degree_x) && (degrees_y[i] <= params->polynome_degree_y)) ? 1 : 0;
		}
		int ret = dlevmar_dif (lm_func, &p[0], &x[0], m, n, 1000, opts, info, NULL, NULL, (void *) &lmdata);

		// Adjust original image
		for (int r = 0; r < height; r++) {
			for (int c = 0; c < width; c++) {
				double y = (double) r / (height - 1);
				double x = (double) c / (width - 1);
				double val = b[r * width + c] - poly4 (x, y, p, lmdata.factors) + avg;
				if (val < 0) val = 0;
				if (val > 1) val = 1;
				b[r * width + c] = (float) val;
			}
		}
		g_free (x);
		g_free (spots);
	}

	gimp_progress_update (p1);
}

unsigned int
polynome_process (GimpDrawable *drawable, GimpDrawable *mask, HParams *params)
{
	// Process main drawable
	int width = drawable->width;
	int height = drawable->height;
	int bpp = drawable->bpp;
	// Source rectangle
	unsigned char *spx = (unsigned char *) g_malloc (width * height * bpp);
	GimpPixelRgn regsrc;
	gimp_pixel_rgn_init (&regsrc, drawable, 0, 0, width, height, 0, 0);
	gimp_pixel_rgn_get_rect (&regsrc, spx, 0, 0, width, height);
	// Mask
	unsigned char *mpx = NULL;
	if (mask && (mask->width == width) && (mask->height == height) && (mask->bpp == 1)) {
		mpx = (unsigned char *) g_malloc(width * height);
		GimpPixelRgn regmask;
		gimp_pixel_rgn_init (&regmask, mask, 0, 0, width, height, 0, 0);
		gimp_pixel_rgn_get_rect (&regmask, mpx, 0, 0, width, height);
	}
	float *mask_buffer = NULL;
	if (mpx) {
		mask_buffer = g_new (float, width * height);
		get_buffer (mask_buffer, width, height, mpx, width, 1, 0);
	}

	// Buffers
	float *b = g_new (float, width * height);
	float *tmp[4];
	for (int i = 0; i < 4; i++) tmp[i] = g_new (float, width * height);
	float progress = 0;
	for (int ch = 0; ch < bpp; ch++) {
		get_buffer (b, width, height, spx, width * bpp, bpp, ch);
		process_channel_lm (b, width, height, mask_buffer, params, tmp, progress, progress + 1.0f / bpp);
		apply_buffer (spx, width, height, width * bpp, bpp, ch, b);
		progress += 1.0f / bpp;
	}
	g_free (b);
	for (int i = 0; i < 4; i++) g_free (tmp[i]);
	if (mask_buffer) g_free (mask_buffer);

	// Copy adjusted image back to drawable
	GimpPixelRgn regdst;
	gimp_pixel_rgn_init (&regdst, drawable, 0, 0, width, height, 1, 1);
	gimp_pixel_rgn_set_rect (&regdst, spx, 0, 0, width, height);
	// Free buffers
	if (mpx) g_free (mpx);
	g_free (spx);
	// Update original and release drawables
	gimp_drawable_merge_shadow (drawable->drawable_id, true);
	gimp_drawable_update (drawable->drawable_id, 0, 0, width, height);
	// if (mask) gimp_drawable_detach (mask);
	// gimp_drawable_detach (drawable);

	return true;
}

#if 0
// Blur image in x dimension by specified kernel, write destination and new weights

static void
blur_x (float *dpx, int width, int height, float *dwx, const float *spx, int ksize, double kernel[])
{
	double maxpixels = 2 * ksize + 1;
	for (int yc = 0; yc < height; yc++) {
		for (int xc = 0; xc < width; xc++) {
			double sumweights = 0;
			double sumvalues = 0;
			double numpixels = 0;
			int x0 = xc - ksize;
			if (x0 < 0) x0 = 0;
			int x1 = xc + ksize;
			if (x1 >= width) x1 = width - 1;
			for (int x = x0; x <= x1; x++) {
				int k = ksize + x - xc;
				double weight = kernel[k];
				sumweights += weight;
				sumvalues += weight * spx[yc * width + x]; 
				numpixels += 1;
			}
			double coverage = maxpixels / numpixels;
			sumweights *= coverage;
			sumvalues *= coverage;
			// Normalize
			if (sumweights) sumvalues /= sumweights;
			dpx[yc * width + xc] = (float) sumvalues;
			dwx[yc * width + xc] = (float) sumweights;
		}
	}
}

// Blur image in y dimension by specified kernel, write destination and new weights

static void
blur_y (float *dpx, int width, int height, float *dwx, const float *spx, const float *swx, int ksize, double kernel[])
{
	double maxpixels = 2 * ksize + 1;
	for (int xc = 0; xc < width; xc++) {
		for (int yc = 0; yc < height; yc++) {
			double sumweights = 0;
			double sumvalues = 0;
			double numpixels = 0;
			// Ignore pixels with zero weigth
			if (swx[yc * width + xc]) {
				int y0 = yc - ksize;
				if (y0 < 0) y0 = 0;
				int y1 = yc + ksize;
				if (y1 >= height) y1 = height - 1;
				for (int y = y0; y <= y1; y++) {
					int k = ksize + y - yc;
					double weight = kernel[k] * swx[y * width + xc];
					sumweights += weight;
					sumvalues += weight * spx[y * width + xc]; 
					numpixels += 1;
				}
			}
			double coverage = maxpixels / numpixels;
			sumweights *= coverage;
			sumvalues *= coverage;
			// Normalize
			if (sumweights) sumvalues /= sumweights;
			dpx[yc * width + xc] = (float) sumvalues;
			dwx[yc * width + xc] = (float) sumweights;
		}
	}
}
#endif

static void
get_hotspot (HotSpot *spot, int x, int y, const float *spx, int width, int height, const float *swx)
{
	spot->x = (double) x / (width - 1);
	spot->y = (double) y / (height - 1);
	spot->value = spx[y * width + x] * swx[y * width + x];
	spot->weight = swx[y * width + x];
}

// Blur image in x dimension by specified gaussian kernel size

static void
blur_x_mask (unsigned char *dpx, int drs, int dbpp, int width, int height, const unsigned char *spx, int srs, int sbpp, double kernelx, double kpower)
{
	// Build kernel
	int kwidth = (int) (kernelx * 2);
	double *w = g_new (double, 2 * kwidth + 1);
	for (int k = -kwidth; k <= kwidth; k++) {
		w[kwidth + k] = exp (-pow (fabs (k / kernelx), kpower));
	}

	for (int y0 = 0; y0 < height; y0++) {
		for (int x0 = 0; x0 < width; x0++) {
			double sumweight = 0;
			double sumimage = 0;
			for (int k = -kwidth; k <= kwidth; k++) {
				int x = x0 + k;
				if ((x >= 0) && (x < width)) {
					double weight = w[kwidth + k];
					sumweight += weight;
					sumimage += weight * spx[y0 * srs + x * sbpp]; 
				}
			}
			dpx[y0 * drs + x0 * dbpp] = (unsigned char) (sumimage / sumweight + 0.5);
		}
	}
	g_free (w);
}

