#ifndef __TEXTUREWERKE_H__
#define __TEXTUREWERKE_H__

//
// Lowpass filter for Gimp
//
// Copyright (C) Lauris Kaplinski 2007-2011
//
// Licensed under GNU GPL
//

#define VERSION "0.11"

#include <gtk/gtk.h>

#include <libgimp/gimp.h>

enum Method { METHOD_COLOR, METHOD_LOWPASS_BLUR, METHOD_LOWPASS_POLYNOME };

struct HParams {
	// Method - color, lowpass blur, lowpass polynome
	unsigned int method;
	// Image parameters
	int layer_id;
	int mask_id;
	int other_layer_id;
	int other_mask_id;
	// Color settings
	unsigned int color_use_blur;
	float color_blur_x;
	float color_blur_y;
	// Blur settings
	float blur_x;
	float blur_y;
	// Lowpass parameters
	float polynome_blur_x;
	float polynome_blur_y;
	double kpower;
	unsigned int polynome_degree_x;
	unsigned int polynome_degree_y;
	unsigned int nsamples;
	unsigned int copylf;
};

// Show main dialog
unsigned int dialog_main_run (HParams *params);
// Build color adjustment widget
GtkWidget *build_color_widget (HParams *params);
// Called if color notebook page is selected
void color_page_selected (GtkWidget *widget, HParams *params);
// Build lowpass filter widget
GtkWidget *build_lowpass_widget (HParams *params);
// Called if lowpass notebook page is selected
void lowpass_page_selected (GtkWidget *widget, HParams *params);
// Build kernel widget
GtkWidget *kernel_widget_new (float *sigma_x, float *sigma_y, float *power, float minsigma, float maxsigma, float sigmastep);

// Process color adjustment
unsigned int color_process (GimpDrawable *drawable, GimpDrawable *mask, HParams *params);
// Homogenize drawable using polynome
unsigned int polynome_process (GimpDrawable *drawable, GimpDrawable *mask, HParams *params);

// Buffers
// Fill float buffer from channel
void get_buffer (float *d, GimpDrawable *drawable, int channel);
void get_buffer (float *d, int width, int height, const unsigned char *px, int rowstride, int bpp, int channel);
// Write float buffer to channel
void apply_buffer (unsigned char *d, int width, int height, int rowstride, int bpp, int channel, const float *b);
// Blur buffer
void blur (float *d, int width, int height, float *dm, const float *s, const float *sm, float *b[], float blurx, float blury, float p0, float p1);

void process_ft (guchar *dpx, int drs, int dbpp, const guchar *spx, int srs, int sbpp, int width, int height, const guchar *mpx, int mrs, int mbpp, float xsigma, float ysigma);

#endif
