(script-fu-register 
	"script-fu-tiles"                        										;func name
	"Tiles"	                         				        						;menu label
	"Creates a tiled image, using random colours set by the user."			;description
	"John Irving"                             									;author
	"copyright 2009, John Irving"             									;copyright notice
	"2009"                          													;date created
	"New Image"                     													;image type that the script works on
	SF-VALUE			"Image Width"					"800"         					;image width
	SF-VALUE			"Image Height"					"600"          				;image height
	SF-VALUE			"Tile Width"					"7"         					;tile width
	SF-VALUE			"Tile Height"					"7"          					;tile height
	SF-COLOR       "Colour 1"						'(40 40 40)			     		;colour variable
	SF-COLOR       "Colour 2"						'(45 45 45)				   	;colour variable
	SF-COLOR       "Colour 3"						'(50 50 50) 			  		;colour variable
	SF-COLOR       "Colour 4"						'(0 0 0)    					;colour variable
	SF-COLOR       "Colour 5"						'(0 0 0)     					;colour variable
	SF-COLOR       "Colour 6"						'(0 0 0)     					;colour variable
	SF-COLOR       "Colour 7"						'(0 0 0)     					;colour variable
	SF-COLOR       "Colour 8"						'(0 0 0)     					;colour variable
	SF-COLOR       "Colour 9"						'(0 0 0)     					;colour variable
	SF-COLOR       "Colour 10"						'(0 0 0)     					;colour variable
	SF-VALUE			"Num of Tile Colours"		"3"          					;num of colours to use
	SF-VALUE			"Grout Width"					"1"          					;grout width
	SF-COLOR       "Grout Colour"					'(35 35 35)   					;grout colour
	SF-VALUE       "Grout Opacity - 0 > 255"	"255"   							;grout opacity
) 
(script-fu-menu-register "script-fu-tiles" "<Toolbox>/Filters/Artistic")
(define (script-fu-tiles inWidth inHeight inTileWidth inTileHeight inColour1 inColour2 inColour3 inColour4 inColour5 inColour6 inColour7 inColour8 inColour9 inColour10 inNumColours inGroutWidth inGroutColour inGroutOpacity)
	(let*
		(
			; define our local variables
			(theImageWidth  inWidth)
			(theImageHeight inHeight)
			(theTileWidth  inTileWidth)
			(theTileHeight inTileHeight)
			(theColour1 inColour1)
			(theColour2 inColour2)
			(theColour3 inColour3)
			(theColour4 inColour4)
			(theColour5 inColour5)
			(theColour6 inColour6)
			(theColour7 inColour7)
			(theColour8 inColour8)
			(theColour9 inColour9)
			(theColour10 inColour10)
			(theColours 
				(list theColour1 
				theColour2 
				theColour3 
				theColour4 
				theColour5 
				theColour6 
				theColour7 
				theColour8 
				theColour9 
				theColour10 
				) 
			) 
			(theNumColours inNumColours) 
			(theGroutWidth inGroutWidth) 
			(theGroutColour inGroutColour) 
			(theGroutOpacity inGroutOpacity) 
			(theColour '(0 0 0))
			(theX 0) 
			(theY 0) 
			(theImage)
			(theImage
				(car
					(gimp-image-new
					theImageWidth
					theImageHeight
					RGB
					)
				)
			)

			;create a new layer for the tiles
			(theTilesLayer
				(car
					(gimp-layer-new
					theImage
					theImageWidth
					theImageHeight
					RGB-IMAGE
					"Tiles"
					100
					NORMAL-MODE
					)
				)
			)
			;create a new layer for the grout
			(theGroutLayer
				(car
					(gimp-layer-new
					theImage
					theImageWidth
					theImageHeight
					RGB-IMAGE
					"Grout"
					100
					NORMAL-MODE
					)
				)
			)

		)
		;end of our local variables

		(gimp-image-add-layer theImage theTilesLayer 1)
		(gimp-context-set-foreground '(0 0 0) )
		(gimp-drawable-fill theTilesLayer FOREGROUND-FILL)

		; draw the tiles
		(while (< theX theImageWidth) 
			(while (< theY theImageHeight) 

				(gimp-rect-select 
					theImage 
					theX 
					theY 
					theTileWidth 
					theTileHeight 
					CHANNEL-OP-REPLACE 
					FALSE 
					0 
				) 
				(set! theColour (list-ref theColours (random theNumColours))) 
				(gimp-context-set-foreground theColour) 
				(gimp-edit-bucket-fill 
					theTilesLayer 
					FG-BUCKET-FILL 
					NORMAL-MODE 
					100 
					0 
					FALSE 
					0 
					0 
				) 
				(set! theY (+ theY theTileHeight)) 
			) 
			(set! theY 0) 
			(set! theX (+ theX theTileWidth)) 
		) 

		; draw the grout lines
		(gimp-image-add-layer theImage theGroutLayer 0) 
		(gimp-layer-add-alpha theGroutLayer) 
		(gimp-selection-all theImage) 
		(gimp-edit-clear theGroutLayer) 

		(plug-in-grid 1 theImage theGroutLayer theGroutWidth theTileWidth 0 theGroutColour theGroutOpacity theGroutWidth theTileHeight 0 theGroutColour theGroutOpacity theGroutWidth 0 0 theGroutColour theGroutOpacity) 

		; display the image
		(gimp-display-new theImage)
		(list theImage theTilesLayer theGroutLayer)
	)
)
