(script-fu-register
	"script-fu-tiles"                        								;func name
	"Tiles"	                         				        				;menu label
	"Creates a tiled image, using random colours set by the user."	;description
	"John Irving"                             							;author
	"copyright 2009, John Irving"             							;copyright notice
	"2009"                          											;date created
	""                     														;image type that the script works on
	SF-VALUE			"Image Width"			"800"         					;image width
	SF-VALUE			"Image Height"			"600"          				;image height
	SF-VALUE			"Tile Width"			"7"         					;tile width
	SF-VALUE			"Tile Height"			"7"          					;tile height
	SF-COLOR       "Colour 1"				'(40 40 40)			     		;color variable
	SF-COLOR       "Colour 2"				'(45 45 45)				   	;color variable
	SF-COLOR       "Colour 3"				'(50 50 50) 			  		;color variable
	SF-COLOR       "Colour 4"				'(0 0 0)    					;color variable
	SF-COLOR       "Colour 5"				'(0 0 0)     					;color variable
	SF-COLOR       "Colour 6"				'(0 0 0)     					;color variable
	SF-COLOR       "Colour 7"				'(0 0 0)     					;color variable
	SF-COLOR       "Colour 8"				'(0 0 0)     					;color variable
	SF-COLOR       "Colour 9"				'(0 0 0)     					;color variable
	SF-COLOR       "Colour 10"				'(0 0 0)     					;color variable
	SF-VALUE			"Num of Colours"		"3"          					;colours to use
	SF-COLOR       "Grout Colour"			'(35 35 35)   					;color variable
	SF-BRUSH			"Grout Brush"			'("1 px square" 100 1 0)	;brush for grout
) 
(script-fu-menu-register "script-fu-tiles" "<Toolbox>/Filters/Artistic")
(define (script-fu-tiles inWidth inHeight inTileWidth inTileHeight inColour1 inColour2 inColour3 inColour4 inColour5 inColour6 inColour7 inColour8 inColour9 inColour10 inNumColours inGroutColour inGroutBrush)
	(let*
		(
			; define our local variables
			(theImageWidth  inWidth)
			(theImageHeight inHeight)
			(theTileWidth  inTileWidth)
			(theTileHeight inTileHeight)
			(theColour1 inColour1)
			(theColour2 inColour2)
			(theColour3 inColour3)
			(theColour4 inColour4)
			(theColour5 inColour5)
			(theColour6 inColour6)
			(theColour7 inColour7)
			(theColour8 inColour8)
			(theColour9 inColour9)
			(theColour10 inColour10)
			(theColours 
				(list theColour1 
				theColour2 
				theColour3 
				theColour4 
				theColour5 
				theColour6 
				theColour7 
				theColour8 
				theColour9 
				theColour10 
				) 
			) 
			(theNumColours inNumColours)
			(theGroutColour inGroutColour)
			(theGroutBrush inGroutBrush)
			(theColour '(0 0 0))
			(theX 0) 
			(theY 0) 
			(*theGroutPoints* (cons-array 4 'double))
			(theImage)
			(theImage
				(car
					(gimp-image-new
					theImageWidth
					theImageHeight
					RGB
					)
				)
			)

			;create a new layer for the tiles
			(theTilesLayer
				(car
					(gimp-layer-new
					theImage
					theImageWidth
					theImageHeight
					RGB-IMAGE
					"Tiles"
					100
					NORMAL-MODE
					)
				)
			)
			;create a new layer for the grout
			(theGroutLayer
				(car
					(gimp-layer-new
					theImage
					theImageWidth
					theImageHeight
					RGB-IMAGE
					"Grout"
					100
					NORMAL-MODE
					)
				)
			)

		)
		;end of our local variables

		(gimp-image-add-layer theImage theTilesLayer 1)
		(gimp-context-set-foreground '(0 0 0) )
		(gimp-drawable-fill theTilesLayer FOREGROUND-FILL)

		; draw the tiles
		(while (< theX theImageWidth) 
			(while (< theY theImageHeight) 

				(gimp-rect-select 
					theImage 
					theX 
					theY 
					theTileWidth 
					theTileHeight 
					CHANNEL-OP-REPLACE 
					FALSE 
					0 
				) 
				(set! theColour (list-ref theColours (random theNumColours))) 
				(gimp-context-set-foreground theColour) 
				(gimp-edit-bucket-fill 
					theTilesLayer 
					FG-BUCKET-FILL 
					NORMAL-MODE 
					100 
					0 
					FALSE 
					0 
					0 
				) 
				(set! theY (+ theY theTileHeight)) 
			) 
			(set! theY 0) 
			(set! theX (+ theX theTileWidth)) 
		) 

		; draw the grout lines
		(set! theX 0) 
		(set! theY 0) 
		(gimp-image-add-layer theImage theGroutLayer 0) 
		(gimp-layer-add-alpha theGroutLayer) 
		(gimp-selection-all theImage) 
		(gimp-edit-clear theGroutLayer) 
		(gimp-context-set-foreground theGroutColour) 
		(gimp-context-set-brush (car theGroutBrush))

		(while (< theX theImageWidth) 
			(aset *theGroutPoints* 0 theX) 
			(aset *theGroutPoints* 1 0) 
			(aset *theGroutPoints* 2 theX) 
			(aset *theGroutPoints* 3 theImageHeight) 
			(gimp-pencil theGroutLayer 4 *theGroutPoints*) 
			(set! theX (+ theX theTileWidth)) 
		) 

		(while (< theY theImageHeight) 
			(aset *theGroutPoints* 0 0) 
			(aset *theGroutPoints* 1 theY) 
			(aset *theGroutPoints* 2 theImageWidth) 
			(aset *theGroutPoints* 3 theY) 
			(gimp-pencil theGroutLayer 4 *theGroutPoints*) 
			(set! theY (+ theY theTileHeight)) 
		) 

		; display the image
		(gimp-display-new theImage)
		(list theImage theTilesLayer theGroutLayer)
	)
)
