(script-fu-register 
	"script-fu-tiles2"                        									;func name
	"Tiles2"	                         				        						;menu label
	"Creates a tiled image, using random colours set by the user."			;description
	"John Irving"                             									;author
	"copyright 2009, John Irving"             									;copyright notice
	"2009"                          													;date created
	"New Image"                     													;image type that the script works on
	SF-VALUE			"Image Width:"					"800"         					;image width
	SF-VALUE			"Image Height:"				"600"          				;image height
	SF-VALUE			"Tile Width:"					"7"         					;tile width
	SF-VALUE			"Tile Height:"					"7"          					;tile height
	SF-COLOR       "Colour 1:"						'(40 40 40)			     		;color variable
	SF-VALUE			"Colour 1 Percent:"			"33"          					;colour percent
	SF-COLOR       "Colour 2:"						'(45 45 45)				   	;color variable
	SF-VALUE			"Colour 2 Percent:"			"32"          					;colour percent
	SF-COLOR       "Colour 3:"						'(50 50 50) 			  		;color variable
	SF-VALUE			"Colour 3 Percent:"			"32"          					;colour percent
	SF-COLOR       "Colour 4:"						'(0 60 0)    					;color variable
	SF-VALUE			"Colour 4 Percent:"			"1"          					;colour percent
	SF-COLOR       "Colour 5:"						'(0 75 0)     					;color variable
	SF-VALUE			"Colour 5 Percent:"			"1"          					;colour percent
	SF-COLOR       "Colour 6:"						'(0 90 0)     					;color variable
	SF-VALUE			"Colour 6 Percent:"			"1"          					;colour percent
	SF-VALUE			"Num of Tile Colours"		"6"          					;num of colours to use
	SF-VALUE			"Grout Width"					"1"          					;grout width
	SF-COLOR       "Grout Colour"					'(35 35 35)   					;grout colour
	SF-VALUE       "Grout Opacity - 0 > 255"	"255"   							;grout opacityt
) 
(script-fu-menu-register "script-fu-tiles2" "<Toolbox>/Filters/Artistic")
(define (script-fu-tiles2 inWidth inHeight inTileWidth inTileHeight inColour1 inColourPerc1 inColour2 inColourPerc2 inColour3 inColourPerc3 inColour4 inColourPerc4 inColour5 inColourPerc5 inColour6 inColourPerc6 inNumColours inGroutWidth inGroutColour inGroutOpacity)
	(let*
		(
			; define our local variables
			(theImageWidth  inWidth)
			(theImageHeight inHeight)
			(theTileWidth  inTileWidth)
			(theTileHeight inTileHeight)
			(theColour1 inColour1) 
			(theColourPerc1 inColourPerc1) 
			(theColour2 inColour2) 
			(theColourPerc2 inColourPerc2) 
			(theColour3 inColour3) 
			(theColourPerc3 inColourPerc3) 
			(theColour4 inColour4) 
			(theColourPerc4 inColourPerc4) 
			(theColour5 inColour5) 
			(theColourPerc5 inColourPerc5) 
			(theColour6 inColour6) 
			(theColourPerc6 inColourPerc6) 
			(theColours 
				(list theColour1 
				theColour2 
				theColour3 
				theColour4 
				theColour5 
				theColour6 
				) 
			) 
			(theColourPercents 
				(list 0 
				(+ theColourPerc1) 
				(+ theColourPerc1 theColourPerc2) 
				(+ theColourPerc1 theColourPerc2 theColourPerc3) 
				(+ theColourPerc1 theColourPerc2 theColourPerc3 theColourPerc4) 
				(+ theColourPerc1 theColourPerc2 theColourPerc3 theColourPerc4 theColourPerc5) 
				) 
			) 
			(thePercent 0)
			(theNumColours inNumColours)
			(theGroutWidth inGroutWidth) 
			(theGroutColour inGroutColour) 
			(theGroutOpacity inGroutOpacity) 
			(theColour '(0 0 0))
			(theX 0) 
			(theY 0) 
			(theImage)
			(theImage
				(car
					(gimp-image-new
					theImageWidth
					theImageHeight
					RGB
					)
				)
			)

			;create a new layer for the tiles
			(theTilesLayer
				(car
					(gimp-layer-new
					theImage
					theImageWidth
					theImageHeight
					RGB-IMAGE
					"Tiles"
					100
					NORMAL-MODE
					)
				)
			)
			;create a new layer for the grout
			(theGroutLayer
				(car
					(gimp-layer-new
					theImage
					theImageWidth
					theImageHeight
					RGB-IMAGE
					"Grout"
					100
					NORMAL-MODE
					)
				)
			)

		)
		;end of our local variables

		(gimp-image-add-layer theImage theTilesLayer 1)
		(gimp-context-set-foreground '(0 0 0) )
		(gimp-drawable-fill theTilesLayer FOREGROUND-FILL)

		; draw the tiles
		(while (< theX theImageWidth) 
			(while (< theY theImageHeight) 

				(gimp-rect-select 
					theImage 
					theX 
					theY 
					theTileWidth 
					theTileHeight 
					CHANNEL-OP-REPLACE 
					FALSE 
					0 
				) 
				(set! thePercent (random 100)) 
				(if (>= theNumColours 1) 
					(if (>= thePercent (list-ref theColourPercents 0)) 
						(set! theColour (list-ref theColours 0)) 
					) 
				) 
				(if (>= theNumColours 2) 
					(if (>= thePercent (list-ref theColourPercents 1)) 
						(set! theColour (list-ref theColours 1)) 
					) 
				) 
				(if (>= theNumColours 3) 
					(if (>= thePercent (list-ref theColourPercents 2)) 
						(set! theColour (list-ref theColours 2)) 
					) 
				) 
				(if (>= theNumColours 4) 
					(if (>= thePercent (list-ref theColourPercents 3)) 
						(set! theColour (list-ref theColours 3)) 
					) 
				) 
				(if (>= theNumColours 5) 
					(if (>= thePercent (list-ref theColourPercents 4)) 
						(set! theColour (list-ref theColours 4)) 
					) 
				) 
				(if (>= theNumColours 6) 
					(if (>= thePercent (list-ref theColourPercents 5)) 
						(set! theColour (list-ref theColours 5)) 
					) 
				) 
				(gimp-context-set-foreground theColour) 
				(gimp-edit-bucket-fill 
					theTilesLayer 
					FG-BUCKET-FILL 
					NORMAL-MODE 
					100 
					0 
					FALSE 
					0 
					0 
				) 
				(set! theY (+ theY theTileHeight)) 
			) 
			(set! theY 0) 
			(set! theX (+ theX theTileWidth)) 
		) 

		; draw the grout lines
		(gimp-image-add-layer theImage theGroutLayer 0) 
		(gimp-layer-add-alpha theGroutLayer) 
		(gimp-selection-all theImage) 
		(gimp-edit-clear theGroutLayer) 

		(plug-in-grid 1 theImage theGroutLayer theGroutWidth theTileWidth 0 theGroutColour theGroutOpacity theGroutWidth theTileHeight 0 theGroutColour theGroutOpacity theGroutWidth 0 0 theGroutColour theGroutOpacity) 

		; display the image
		(gimp-display-new theImage)
		(list theImage theTilesLayer theGroutLayer)
	)
)
